/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.producer;

import io.cloudevents.CloudEvent;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.runtime.boot.AbstractRemotingServer;
import org.apache.eventmesh.runtime.core.protocol.RetryContext;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageContext
extends RetryContext {
    public static final Logger logger = LoggerFactory.getLogger((String)"retry");
    private CloudEvent event;
    private String bizSeqNo;
    private EventMeshProducer eventMeshProducer;
    private long createTime = System.currentTimeMillis();
    public AbstractRemotingServer eventMeshServer;

    public SendMessageContext(String bizSeqNo, CloudEvent event, EventMeshProducer eventMeshProducer, AbstractRemotingServer eventMeshServer) {
        this.bizSeqNo = bizSeqNo;
        this.event = event;
        this.eventMeshProducer = eventMeshProducer;
        this.eventMeshServer = eventMeshServer;
    }

    public String getBizSeqNo() {
        return this.bizSeqNo;
    }

    public void setBizSeqNo(String bizSeqNo) {
        this.bizSeqNo = bizSeqNo;
    }

    public CloudEvent getEvent() {
        return this.event;
    }

    @Override
    public void setEvent(CloudEvent event) {
        this.event = event;
    }

    public EventMeshProducer getEventMeshProducer() {
        return this.eventMeshProducer;
    }

    public void setEventMeshProducer(EventMeshProducer eventMeshProducer) {
        this.eventMeshProducer = eventMeshProducer;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sendMessageContext={").append("bizSeqNo=").append(this.bizSeqNo).append(",retryTimes=").append(this.retryTimes).append(",producer=").append(this.eventMeshProducer != null ? this.eventMeshProducer : null).append(",executeTime=").append(DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append(",createTime=").append(DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append("}");
        return sb.toString();
    }

    public void retry() throws Exception {
        if (this.eventMeshProducer == null) {
            logger.error("Exception happends during retry. EventMeshProducer is null.");
            return;
        }
        if (this.retryTimes > 0) {
            logger.error("Exception happends during retry. The retryTimes > 0.");
            return;
        }
        ++this.retryTimes;
        this.eventMeshProducer.send(this, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(OnExceptionContext context) {
                logger.warn("", (Throwable)context.getException());
            }
        });
    }

    @Override
    public void doRun() throws Exception {
        this.retry();
    }
}

