/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.enums.ProtocolType;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.metrics.api.MetricsRegistry;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.metrics.MetricsManager;
import org.apache.eventmesh.runtime.metrics.MetricsUtils;
import org.apache.eventmesh.runtime.metrics.http.HttpMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshHttpMetricsManager
implements MetricsManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshHttpMetricsManager.class);
    private Map<String, String> labelMap = new HashMap<String, String>();
    private final EventMeshHTTPServer eventMeshHTTPServer;
    private final List<MetricsRegistry> metricsRegistries;
    private final HttpMetrics httpMetrics;
    private static ScheduledExecutorService metricsSchedule = Executors.newScheduledThreadPool(2, (ThreadFactory)new EventMeshThreadFactory("eventMesh-metrics", true));

    public EventMeshHttpMetricsManager(EventMeshHTTPServer eventMeshHTTPServer, List<MetricsRegistry> metricsRegistries) {
        Objects.requireNonNull(eventMeshHTTPServer, "EventMeshHTTPServer can not be null");
        Objects.requireNonNull(metricsRegistries, "List<MetricsRegistry> can not be null");
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.metricsRegistries = metricsRegistries;
        this.init();
        this.httpMetrics = new HttpMetrics(eventMeshHTTPServer.getHttpThreadPoolGroup().getBatchMsgExecutor(), eventMeshHTTPServer.getHttpThreadPoolGroup().getSendMsgExecutor(), eventMeshHTTPServer.getHttpThreadPoolGroup().getPushMsgExecutor(), new DelayQueue(), this.labelMap);
    }

    private void init() {
        boolean useTls = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().isEventMeshServerUseTls();
        String eventMeshServerIp = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshServerIp();
        int httpServerPort = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getHttpServerPort();
        this.labelMap.put("http.scheme", useTls ? "https" : "http");
        this.labelMap.put("http.flavor", "1.1");
        this.labelMap.put("net.host.name", Optional.ofNullable(eventMeshServerIp).orElse(IPUtils.getLocalAddress()));
        this.labelMap.put("net.host.port", Integer.toString(httpServerPort));
        this.labelMap.put("rpc.system", "HTTP");
        this.labelMap.put("rpc.service", this.eventMeshHTTPServer.getClass().getName());
        if (log.isInfoEnabled()) {
            log.info("HTTPMetricsServer initialized.");
        }
    }

    @Override
    public void start() {
        metricsSchedule.scheduleAtFixedRate(() -> {
            try {
                this.httpMetrics.snapshotHTTPTPS();
                this.httpMetrics.snapshotSendBatchMsgTPS();
                this.httpMetrics.snapshotSendMsgTPS();
                this.httpMetrics.snapshotPushMsgTPS();
            }
            catch (Exception ex) {
                log.error("eventMesh snapshot tps metrics err", (Throwable)ex);
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
        metricsSchedule.scheduleAtFixedRate(() -> {
            try {
                this.logPrintServerMetrics(this.httpMetrics, this.eventMeshHTTPServer);
            }
            catch (Exception ex) {
                log.error("eventMesh print metrics err", (Throwable)ex);
            }
        }, 1000L, 30000L, TimeUnit.MILLISECONDS);
        if (log.isInfoEnabled()) {
            log.info("HTTPMetricsServer started.");
        }
    }

    public void recordReceiveMsgFromClient(String clientAddress) {
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        attributes.put("client.protocol.type", ProtocolType.GRPC.name());
        attributes.put("client.address", Optional.ofNullable(clientAddress).orElse("unkown"));
        MetricsUtils.incrementClientToEventMeshMsgNum(attributes);
    }

    public void recordReceiveMsgFromClient(int count, String clientAddress) {
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        attributes.put("client.protocol.type", ProtocolType.GRPC.name());
        attributes.put("client.address", Optional.ofNullable(clientAddress).orElse("unkown"));
        MetricsUtils.incrementClientToEventMeshMsgNum(attributes, count);
    }

    public void recordSendMsgToQueue() {
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        MetricsUtils.incrementEventMeshToMQMsgNum(attributes);
    }

    public void recordReceiveMsgFromQueue() {
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        MetricsUtils.incrementMQToEventMeshMsgNum(attributes);
    }

    public void recordSendMsgToClient(String clientAddress) {
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        attributes.put("client.protocol.type", ProtocolType.TCP.name());
        attributes.put("client.address", Optional.ofNullable(clientAddress).orElse("unkown"));
        MetricsUtils.incrementEventMeshToClientMsgNum(attributes);
    }

    @Override
    public void shutdown() {
        metricsSchedule.shutdown();
    }

    private void logPrintServerMetrics(HttpMetrics summaryMetrics, EventMeshHTTPServer eventMeshHTTPServer) {
        if (log.isInfoEnabled()) {
            log.info("===========================================HTTP SERVER METRICS==================================================");
            log.info("maxHTTPTPS: {}, avgHTTPTPS: {}, maxHTTPCOST: {}, avgHTTPCOST: {}, avgHTTPBodyDecodeCost: {}, httpDiscard: {}", new Object[]{summaryMetrics.maxHTTPTPS(), summaryMetrics.avgHTTPTPS(), summaryMetrics.maxHTTPCost(), summaryMetrics.avgHTTPCost(), summaryMetrics.avgHTTPBodyDecodeCost(), summaryMetrics.getHttpDiscard()});
        }
        summaryMetrics.httpStatInfoClear();
        if (log.isInfoEnabled()) {
            log.info("maxBatchSendMsgTPS: {}, avgBatchSendMsgTPS: {}, sum: {}. sumFail: {}, sumFailRate: {}, discard : {}", new Object[]{summaryMetrics.maxSendBatchMsgTPS(), summaryMetrics.avgSendBatchMsgTPS(), summaryMetrics.getSendBatchMsgNumSum(), summaryMetrics.getSendBatchMsgFailNumSum(), summaryMetrics.getSendBatchMsgFailRate(), summaryMetrics.getSendBatchMsgDiscardNumSum()});
        }
        summaryMetrics.cleanSendBatchStat();
        if (log.isInfoEnabled()) {
            log.info("maxSendMsgTPS: {}, avgSendMsgTPS: {}, sum: {}, sumFail: {}, sumFailRate: {}, replyMsg: {}, replyFail: {}", new Object[]{summaryMetrics.maxSendMsgTPS(), summaryMetrics.avgSendMsgTPS(), summaryMetrics.getSendMsgNumSum(), summaryMetrics.getSendMsgFailNumSum(), Float.valueOf(summaryMetrics.getSendMsgFailRate()), summaryMetrics.getReplyMsgNumSum(), summaryMetrics.getReplyMsgFailNumSum()});
        }
        summaryMetrics.cleanSendMsgStat();
        if (log.isInfoEnabled()) {
            log.info("maxPushMsgTPS: {}, avgPushMsgTPS: {}, sum: {}, sumFail: {}, sumFailRate: {}, maxClientLatency: {}, avgClientLatency: {}", new Object[]{summaryMetrics.maxPushMsgTPS(), summaryMetrics.avgPushMsgTPS(), summaryMetrics.getHttpPushMsgNumSum(), summaryMetrics.getHttpPushFailNumSum(), summaryMetrics.getHttpPushMsgFailRate(), summaryMetrics.maxHTTPPushLatency(), summaryMetrics.avgHTTPPushLatency()});
        }
        summaryMetrics.cleanHttpPushMsgStat();
        if (log.isInfoEnabled()) {
            log.info("batchMsgQ: {}, sendMsgQ: {}, pushMsgQ: {}", new Object[]{eventMeshHTTPServer.getHttpThreadPoolGroup().getBatchMsgExecutor().getQueue().size(), eventMeshHTTPServer.getHttpThreadPoolGroup().getSendMsgExecutor().getQueue().size(), eventMeshHTTPServer.getHttpThreadPoolGroup().getPushMsgExecutor().getQueue().size()});
        }
        if (log.isInfoEnabled()) {
            log.info("batchAvgSend2MQCost: {}, avgSend2MQCost: {}, avgReply2MQCost: {}", new Object[]{summaryMetrics.avgBatchSendMsgCost(), summaryMetrics.avgSendMsgCost(), summaryMetrics.avgReplyMsgCost()});
        }
        summaryMetrics.send2MQStatInfoClear();
    }

    public HttpMetrics getHttpMetrics() {
        return this.httpMetrics;
    }

    @Override
    public List<Metric> getMetrics() {
        return new ArrayList<Metric>(this.httpMetrics.getMetrics());
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

