/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.tcp;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.eventmesh.metrics.api.model.InstrumentFurther;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.api.model.ObservableDoubleGaugeMetric;
import org.apache.eventmesh.metrics.api.model.ObservableLongGaugeMetric;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpMetrics {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TcpMetrics.class);
    private static final String TPC_METRICS_NAME_PREFIX = "eventmesh.tcp.";
    private static final String METRIC_NAME = "TCP";
    private final EventMeshTCPServer eventMeshTCPServer;
    private AtomicLong client2eventMeshMsgNum;
    private AtomicLong eventMesh2mqMsgNum;
    private AtomicLong mq2eventMeshMsgNum;
    private AtomicLong eventMesh2clientMsgNum;
    private volatile double client2eventMeshTPS;
    private volatile double eventMesh2clientTPS;
    private volatile double eventMesh2mqTPS;
    private volatile double mq2eventMeshTPS;
    private int subTopicNum;
    private volatile int allConnections;
    private volatile int retrySize;
    private ObservableLongGaugeMetric allConnectionsGauge;
    private ObservableLongGaugeMetric retrySizeGauge;
    private ObservableLongGaugeMetric subTopicGauge;
    private ObservableDoubleGaugeMetric mq2eventMeshTPSGauge;
    private ObservableDoubleGaugeMetric client2eventMeshTPSGauge;
    private ObservableDoubleGaugeMetric eventMesh2clientTPSGauge;
    private ObservableDoubleGaugeMetric eventMesh2mqTPSGauge;
    private final Map<String, String> labelMap;
    private final Map<String, Metric> metrics = new HashMap<String, Metric>(32);

    public TcpMetrics(EventMeshTCPServer eventMeshTCPServer, Map<String, String> labelMap) {
        this.client2eventMeshMsgNum = new AtomicLong(0L);
        this.eventMesh2mqMsgNum = new AtomicLong(0L);
        this.mq2eventMeshMsgNum = new AtomicLong(0L);
        this.eventMesh2clientMsgNum = new AtomicLong(0L);
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.labelMap = labelMap;
        this.initMetric();
    }

    private void initMetric() {
        HashMap<String, String> commonAttributes = new HashMap<String, String>(this.labelMap);
        InstrumentFurther furtherConn = new InstrumentFurther();
        furtherConn.setUnit("1");
        furtherConn.setDescription("Number of TCP client connects to EventMesh runtime");
        furtherConn.setName("eventmesh.tcp.connection.num");
        this.allConnectionsGauge = new ObservableLongGaugeMetric(furtherConn, METRIC_NAME, this.buildAllConnectionSupplier());
        this.allConnectionsGauge.putAll(commonAttributes);
        this.metrics.put("allConnections", (Metric)this.allConnectionsGauge);
        InstrumentFurther furtherTopic = new InstrumentFurther();
        furtherTopic.setUnit("1");
        furtherTopic.setDescription("Number of TCP client subscribe for topic");
        furtherTopic.setName("eventmesh.tcp.sub.topic.num");
        this.subTopicGauge = new ObservableLongGaugeMetric(furtherTopic, METRIC_NAME, this.buildSubTopicSupplier());
        this.subTopicGauge.putAll(commonAttributes);
        this.metrics.put("subTopicGauge", (Metric)this.subTopicGauge);
        InstrumentFurther furtherCl2Em = new InstrumentFurther();
        furtherCl2Em.setUnit("tps");
        furtherCl2Em.setDescription("Tps of client to EventMesh.");
        furtherCl2Em.setName("eventmesh.tcp.client.eventmesh.tps");
        this.client2eventMeshTPSGauge = new ObservableDoubleGaugeMetric(furtherCl2Em, METRIC_NAME, () -> this.client2eventMeshTPS);
        this.client2eventMeshTPSGauge.putAll(commonAttributes);
        this.metrics.put("client2eventMeshTPSGauge", (Metric)this.client2eventMeshTPSGauge);
        InstrumentFurther furtherEm2Cl = new InstrumentFurther();
        furtherEm2Cl.setUnit("tps");
        furtherEm2Cl.setDescription("Tps of EventMesh to client.");
        furtherEm2Cl.setName("eventmesh.tcp.eventmesh.client.tps");
        this.eventMesh2clientTPSGauge = new ObservableDoubleGaugeMetric(furtherEm2Cl, METRIC_NAME, () -> this.eventMesh2clientTPS);
        this.eventMesh2clientTPSGauge.putAll(commonAttributes);
        this.metrics.put("eventMesh2clientTPSGauge", (Metric)this.eventMesh2clientTPSGauge);
        InstrumentFurther furtherEm2Mq = new InstrumentFurther();
        furtherEm2Mq.setUnit("tps");
        furtherEm2Mq.setDescription("Tps of EventMesh to MQ.");
        furtherEm2Mq.setName("eventmesh.tcp.eventmesh.mq.tps");
        this.eventMesh2mqTPSGauge = new ObservableDoubleGaugeMetric(furtherEm2Mq, METRIC_NAME, () -> this.eventMesh2mqTPS);
        this.eventMesh2mqTPSGauge.putAll(commonAttributes);
        this.metrics.put("eventMesh2mqTPSGauge", (Metric)this.eventMesh2mqTPSGauge);
        InstrumentFurther furtherMq2Em = new InstrumentFurther();
        furtherMq2Em.setUnit("tps");
        furtherMq2Em.setDescription("Tps of MQ to EventMesh.");
        furtherMq2Em.setName("eventmesh.tcp.mq.eventmesh.tps");
        this.mq2eventMeshTPSGauge = new ObservableDoubleGaugeMetric(furtherMq2Em, METRIC_NAME, () -> this.eventMesh2mqTPS);
        this.mq2eventMeshTPSGauge.putAll(commonAttributes);
        this.metrics.put("mq2eventMeshTPSGauge", (Metric)this.mq2eventMeshTPSGauge);
    }

    private Supplier<Long> buildAllConnectionSupplier() {
        return () -> this.eventMeshTCPServer.getTcpConnectionHandler().getConnectionCount();
    }

    private Supplier<Long> buildSubTopicSupplier() {
        return () -> {
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = this.eventMeshTCPServer.getClientSessionGroupMapping().getSessionMap();
            Iterator<Session> sessionIterator = sessionMap.values().iterator();
            HashSet topicSet = new HashSet();
            while (sessionIterator.hasNext()) {
                Session session = sessionIterator.next();
                AtomicLong deliveredMsgsCount = session.getPusher().getDeliveredMsgsCount();
                AtomicLong deliveredFailCount = session.getPusher().getDeliverFailMsgsCount();
                int unAckMsgsCount = session.getPusher().getTotalUnackMsgs();
                int sendTopics = session.getSessionContext().getSendTopics().size();
                int subscribeTopics = session.getSessionContext().getSubscribeTopics().size();
                log.info("session|deliveredFailCount={}|deliveredMsgsCount={}|unAckMsgsCount={}|sendTopics={}|subscribeTopics={}|user={}", new Object[]{deliveredFailCount.longValue(), deliveredMsgsCount.longValue(), unAckMsgsCount, sendTopics, subscribeTopics, session.getClient()});
                topicSet.addAll(session.getSessionContext().getSubscribeTopics().keySet());
            }
            return topicSet.size();
        };
    }

    public Collection<Metric> getMetrics() {
        return this.metrics.values();
    }

    public long client2eventMeshMsgNum() {
        return this.client2eventMeshMsgNum.get();
    }

    public long eventMesh2mqMsgNum() {
        return this.eventMesh2mqMsgNum.get();
    }

    public long mq2eventMeshMsgNum() {
        return this.mq2eventMeshMsgNum.get();
    }

    public long eventMesh2clientMsgNum() {
        return this.eventMesh2clientMsgNum.get();
    }

    public void resetClient2EventMeshMsgNum() {
        this.client2eventMeshMsgNum = new AtomicLong(0L);
    }

    public void resetEventMesh2mqMsgNum() {
        this.eventMesh2mqMsgNum = new AtomicLong(0L);
    }

    public void resetMq2eventMeshMsgNum() {
        this.mq2eventMeshMsgNum = new AtomicLong(0L);
    }

    public void resetEventMesh2ClientMsgNum() {
        this.eventMesh2clientMsgNum = new AtomicLong(0L);
    }

    public void setClient2eventMeshTPS(double client2eventMeshTPS) {
        this.client2eventMeshTPS = client2eventMeshTPS;
    }

    public double getEventMesh2clientTPS() {
        return this.eventMesh2clientTPS;
    }

    public void setEventMesh2clientTPS(double eventMesh2clientTPS) {
        this.eventMesh2clientTPS = eventMesh2clientTPS;
    }

    public double getEventMesh2mqTPS() {
        return this.eventMesh2mqTPS;
    }

    public void setEventMesh2mqTPS(double eventMesh2mqTPS) {
        this.eventMesh2mqTPS = eventMesh2mqTPS;
    }

    public double getMq2eventMeshTPS() {
        return this.mq2eventMeshTPS;
    }

    public void setMq2eventMeshTPS(double mq2eventMeshTPS) {
        this.mq2eventMeshTPS = mq2eventMeshTPS;
    }

    public double getAllTPS() {
        return this.client2eventMeshTPS + this.eventMesh2clientTPS;
    }

    public int getSubTopicNum() {
        return this.subTopicNum;
    }

    public void setSubTopicNum(int subTopicNum) {
        this.subTopicNum = subTopicNum;
    }

    public int getAllConnections() {
        return this.allConnections;
    }

    public void setAllConnections(int allConnections) {
        this.allConnections = allConnections;
    }

    public void setRetrySize(int retrySize) {
        this.retrySize = retrySize;
    }

    public int getRetrySize() {
        return this.retrySize;
    }

    @Generated
    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    @Generated
    public AtomicLong getClient2eventMeshMsgNum() {
        return this.client2eventMeshMsgNum;
    }

    @Generated
    public AtomicLong getEventMesh2mqMsgNum() {
        return this.eventMesh2mqMsgNum;
    }

    @Generated
    public AtomicLong getMq2eventMeshMsgNum() {
        return this.mq2eventMeshMsgNum;
    }

    @Generated
    public AtomicLong getEventMesh2clientMsgNum() {
        return this.eventMesh2clientMsgNum;
    }

    @Generated
    public double getClient2eventMeshTPS() {
        return this.client2eventMeshTPS;
    }

    @Generated
    public ObservableLongGaugeMetric getAllConnectionsGauge() {
        return this.allConnectionsGauge;
    }

    @Generated
    public ObservableLongGaugeMetric getRetrySizeGauge() {
        return this.retrySizeGauge;
    }

    @Generated
    public ObservableLongGaugeMetric getSubTopicGauge() {
        return this.subTopicGauge;
    }

    @Generated
    public ObservableDoubleGaugeMetric getMq2eventMeshTPSGauge() {
        return this.mq2eventMeshTPSGauge;
    }

    @Generated
    public ObservableDoubleGaugeMetric getClient2eventMeshTPSGauge() {
        return this.client2eventMeshTPSGauge;
    }

    @Generated
    public ObservableDoubleGaugeMetric getEventMesh2clientTPSGauge() {
        return this.eventMesh2clientTPSGauge;
    }

    @Generated
    public ObservableDoubleGaugeMetric getEventMesh2mqTPSGauge() {
        return this.eventMesh2mqTPSGauge;
    }

    @Generated
    public Map<String, String> getLabelMap() {
        return this.labelMap;
    }

    @Generated
    public void setClient2eventMeshMsgNum(AtomicLong client2eventMeshMsgNum) {
        this.client2eventMeshMsgNum = client2eventMeshMsgNum;
    }

    @Generated
    public void setEventMesh2mqMsgNum(AtomicLong eventMesh2mqMsgNum) {
        this.eventMesh2mqMsgNum = eventMesh2mqMsgNum;
    }

    @Generated
    public void setMq2eventMeshMsgNum(AtomicLong mq2eventMeshMsgNum) {
        this.mq2eventMeshMsgNum = mq2eventMeshMsgNum;
    }

    @Generated
    public void setEventMesh2clientMsgNum(AtomicLong eventMesh2clientMsgNum) {
        this.eventMesh2clientMsgNum = eventMesh2clientMsgNum;
    }

    @Generated
    public void setAllConnectionsGauge(ObservableLongGaugeMetric allConnectionsGauge) {
        this.allConnectionsGauge = allConnectionsGauge;
    }

    @Generated
    public void setRetrySizeGauge(ObservableLongGaugeMetric retrySizeGauge) {
        this.retrySizeGauge = retrySizeGauge;
    }

    @Generated
    public void setSubTopicGauge(ObservableLongGaugeMetric subTopicGauge) {
        this.subTopicGauge = subTopicGauge;
    }

    @Generated
    public void setMq2eventMeshTPSGauge(ObservableDoubleGaugeMetric mq2eventMeshTPSGauge) {
        this.mq2eventMeshTPSGauge = mq2eventMeshTPSGauge;
    }

    @Generated
    public void setClient2eventMeshTPSGauge(ObservableDoubleGaugeMetric client2eventMeshTPSGauge) {
        this.client2eventMeshTPSGauge = client2eventMeshTPSGauge;
    }

    @Generated
    public void setEventMesh2clientTPSGauge(ObservableDoubleGaugeMetric eventMesh2clientTPSGauge) {
        this.eventMesh2clientTPSGauge = eventMesh2clientTPSGauge;
    }

    @Generated
    public void setEventMesh2mqTPSGauge(ObservableDoubleGaugeMetric eventMesh2mqTPSGauge) {
        this.eventMesh2mqTPSGauge = eventMesh2mqTPSGauge;
    }
}

