/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SpellcheckOptions {
    private Integer distance;
    private Integer dialect;
    private List<String> includedTerms = Collections.emptyList();
    private List<String> excludedTerms = Collections.emptyList();
    private String excludedDictionary;
    private String includedDictionary;

    private SpellcheckOptions() {
    }

    public static SpellcheckOptions defaults() {
        return new SpellcheckOptions();
    }

    public SpellcheckOptions distance(Integer distance) {
        this.distance = distance;
        return this;
    }

    public SpellcheckOptions dialect(Integer dialect) {
        this.dialect = dialect;
        return this;
    }

    public SpellcheckOptions includedTerms(String dictionary, String ... includedTerms) {
        this.includedDictionary = dictionary;
        this.includedTerms = Arrays.asList(includedTerms);
        return this;
    }

    public SpellcheckOptions excludedTerms(String dictionary, String ... excludedTerms) {
        this.excludedDictionary = dictionary;
        this.excludedTerms = Arrays.asList(excludedTerms);
        return this;
    }

    public Integer getDistance() {
        return this.distance;
    }

    public Integer getDialect() {
        return this.dialect;
    }

    public List<String> getIncludedTerms() {
        return this.includedTerms;
    }

    public List<String> getExcludedTerms() {
        return this.excludedTerms;
    }

    public String getExcludedDictionary() {
        return this.excludedDictionary;
    }

    public String getIncludedDictionary() {
        return this.includedDictionary;
    }
}

