/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.JsonJacksonCodec;

public class TypedJsonJacksonCodec
extends JsonJacksonCodec {
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream os = new ByteBufOutputStream(out);
                TypedJsonJacksonCodec.this.mapObjectMapper.writeValue((OutputStream)os, in);
                return os.buffer();
            }
            catch (IOException e) {
                out.release();
                throw e;
            }
        }
    };
    private final Decoder<Object> valueDecoder;
    private final Decoder<Object> mapValueDecoder;
    private final Decoder<Object> mapKeyDecoder;
    private final TypeReference<?> valueTypeReference;
    private final TypeReference<?> mapKeyTypeReference;
    private final TypeReference<?> mapValueTypeReference;
    private final Class<?> valueClass;
    private final Class<?> mapKeyClass;
    private final Class<?> mapValueClass;

    private Decoder<Object> createDecoder(final Class<?> valueClass, final TypeReference<?> valueTypeReference) {
        return new Decoder<Object>(){

            @Override
            public Object decode(ByteBuf buf, State state) throws IOException {
                if (valueClass != null) {
                    return TypedJsonJacksonCodec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), valueClass);
                }
                if (valueTypeReference != null) {
                    return TypedJsonJacksonCodec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), valueTypeReference);
                }
                return TypedJsonJacksonCodec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), Object.class);
            }
        };
    }

    public TypedJsonJacksonCodec(Class<?> valueClass) {
        this(null, null, null, valueClass, null, null, new ObjectMapper(), false);
    }

    public TypedJsonJacksonCodec(Class<?> valueClass, ObjectMapper mapper) {
        this(valueClass, null, null, mapper);
    }

    public TypedJsonJacksonCodec(Class<?> mapKeyClass, Class<?> mapValueClass) {
        this(null, mapKeyClass, mapValueClass, new ObjectMapper());
    }

    public TypedJsonJacksonCodec(Class<?> mapKeyClass, Class<?> mapValueClass, ObjectMapper mapper) {
        this(null, mapKeyClass, mapValueClass, mapper);
    }

    public TypedJsonJacksonCodec(Class<?> valueClass, Class<?> mapKeyClass, Class<?> mapValueClass) {
        this(null, null, null, valueClass, mapKeyClass, mapValueClass, new ObjectMapper(), false);
    }

    public TypedJsonJacksonCodec(Class<?> valueClass, Class<?> mapKeyClass, Class<?> mapValueClass, ObjectMapper mapper) {
        this(null, null, null, valueClass, mapKeyClass, mapValueClass, mapper, true);
    }

    public TypedJsonJacksonCodec(TypeReference<?> valueTypeReference) {
        this(valueTypeReference, new ObjectMapper());
    }

    public TypedJsonJacksonCodec(TypeReference<?> valueTypeReference, ObjectMapper mapper) {
        this(valueTypeReference, null, null, mapper);
    }

    public TypedJsonJacksonCodec(TypeReference<?> mapKeyTypeReference, TypeReference<?> mapValueTypeReference) {
        this(null, mapKeyTypeReference, mapValueTypeReference);
    }

    public TypedJsonJacksonCodec(TypeReference<?> mapKeyTypeReference, TypeReference<?> mapValueTypeReference, ObjectMapper mapper) {
        this(null, mapKeyTypeReference, mapValueTypeReference, mapper);
    }

    public TypedJsonJacksonCodec(TypeReference<?> valueTypeReference, TypeReference<?> mapKeyTypeReference, TypeReference<?> mapValueTypeReference) {
        this(valueTypeReference, mapKeyTypeReference, mapValueTypeReference, null, null, null, new ObjectMapper(), false);
    }

    public TypedJsonJacksonCodec(TypeReference<?> valueTypeReference, TypeReference<?> mapKeyTypeReference, TypeReference<?> mapValueTypeReference, ObjectMapper mapper) {
        this(valueTypeReference, mapKeyTypeReference, mapValueTypeReference, null, null, null, mapper, true);
    }

    public TypedJsonJacksonCodec(ClassLoader classLoader, TypedJsonJacksonCodec codec) {
        this(codec.valueTypeReference, codec.mapKeyTypeReference, codec.mapValueTypeReference, codec.valueClass, codec.mapKeyClass, codec.mapValueClass, TypedJsonJacksonCodec.createObjectMapper(classLoader, codec.mapObjectMapper.copy()), false);
    }

    TypedJsonJacksonCodec(TypeReference<?> valueTypeReference, TypeReference<?> mapKeyTypeReference, TypeReference<?> mapValueTypeReference, Class<?> valueClass, Class<?> mapKeyClass, Class<?> mapValueClass, ObjectMapper mapper, boolean copy) {
        super(mapper, copy);
        this.mapValueDecoder = this.createDecoder(mapValueClass, mapValueTypeReference);
        this.mapKeyDecoder = this.createDecoder(mapKeyClass, mapKeyTypeReference);
        this.valueDecoder = this.createDecoder(valueClass, valueTypeReference);
        this.mapValueClass = mapValueClass;
        this.mapValueTypeReference = mapValueTypeReference;
        this.mapKeyClass = mapKeyClass;
        this.mapKeyTypeReference = mapKeyTypeReference;
        this.valueClass = valueClass;
        this.valueTypeReference = valueTypeReference;
    }

    @Override
    protected void initTypeInclusion(ObjectMapper mapObjectMapper) {
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.valueDecoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        return this.mapKeyDecoder;
    }

    @Override
    public Encoder getMapValueEncoder() {
        return this.encoder;
    }

    @Override
    public Encoder getMapKeyEncoder() {
        return this.encoder;
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        return this.mapValueDecoder;
    }
}

