/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.concurrent.atomic.AtomicInteger;

public final class AsyncCountDownLatch {
    private final AtomicInteger commandsSent = new AtomicInteger();
    private volatile Runnable callback;

    public void countDown() {
        if (this.commandsSent.incrementAndGet() == 0) {
            this.callback.run();
        }
    }

    public void latch(Runnable callback, int count) {
        if (this.callback != null) {
            throw new IllegalStateException("Latch can't be called twice");
        }
        this.callback = callback;
        if (this.commandsSent.addAndGet(-count) == 0) {
            callback.run();
        }
    }
}

