/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client.retry;

import com.navercorp.pinpoint.grpc.client.retry.ServiceConfigBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HedgingServiceConfigBuilder
implements ServiceConfigBuilder {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    public static final long DEFAULT_HEDGING_DELAY_MILLIS = 1000L;
    private double maxAttempts = 3.0;
    private String hedgingDelay = this.millisToString(1000L);
    private List<String> nonFatalStatusCodes;

    @Override
    public Map<String, ?> buildMetadataConfig() {
        LinkedHashMap<String, Object> methodConfig = new LinkedHashMap<String, Object>();
        this.addMetadataService(methodConfig);
        this.addHedgingPolicy(methodConfig);
        return Collections.singletonMap("methodConfig", Collections.singletonList(methodConfig));
    }

    private void addMetadataService(Map<String, Object> methodConfig) {
        Map<String, String> service = Collections.singletonMap("service", "v1.metadata");
        methodConfig.put("name", Collections.singletonList(service));
    }

    private void addHedgingPolicy(Map<String, Object> methodConfig) {
        LinkedHashMap<String, Object> retryPolicy = new LinkedHashMap<String, Object>();
        retryPolicy.put("maxAttempts", this.maxAttempts);
        retryPolicy.put("hedgingDelay", this.hedgingDelay);
        if (this.nonFatalStatusCodes != null && !this.nonFatalStatusCodes.isEmpty()) {
            retryPolicy.put("nonFatalStatusCodes", this.nonFatalStatusCodes);
        }
        methodConfig.put("hedgingPolicy", retryPolicy);
    }

    public void setMaxAttempts(int maxAttempts) {
        if (maxAttempts >= 2) {
            this.maxAttempts = maxAttempts;
        }
    }

    public void setHedgingDelayMillis(long hedgingDelay) {
        this.hedgingDelay = this.millisToString(hedgingDelay);
    }

    public void setNonFatalStatusCodes(List<String> nonFatalStatusCodes) {
        this.nonFatalStatusCodes = nonFatalStatusCodes;
    }

    public String millisToString(long value) {
        return (double)value / 1000.0 + "s";
    }
}

