/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.nacos.service;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.exception.MetaException;
import org.apache.eventmesh.api.meta.MetaService;
import org.apache.eventmesh.api.meta.MetaServiceListener;
import org.apache.eventmesh.api.meta.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.meta.nacos.config.NacosMetaStorageConfiguration;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosMetaService
implements MetaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NacosMetaService.class);
    private final AtomicBoolean initStatus = new AtomicBoolean(false);
    private final AtomicBoolean startStatus = new AtomicBoolean(false);
    private String serverAddr;
    private String username;
    private String password;
    private NacosMetaStorageConfiguration nacosConfig;
    private String dataId;
    private String group;
    private NamingService nacosNamingService;
    private com.alibaba.nacos.api.config.ConfigService nacosConfigService;
    private ConcurrentMap<String, EventMeshRegisterInfo> eventMeshRegisterInfoMap;
    private MetaServiceListener metaServiceListener;

    public void init() throws MetaException {
        ConfigService configService;
        NacosMetaStorageConfiguration nacosConfig;
        if (!this.initStatus.compareAndSet(false, true)) {
            return;
        }
        this.eventMeshRegisterInfoMap = new ConcurrentHashMap<String, EventMeshRegisterInfo>(ConfigurationContextUtil.KEYS.size());
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
            if (commonConfiguration == null) continue;
            if (StringUtils.isBlank((CharSequence)commonConfiguration.getMetaStorageAddr())) {
                throw new MetaException("namesrvAddr cannot be null");
            }
            this.serverAddr = commonConfiguration.getMetaStorageAddr();
            this.username = commonConfiguration.getEventMeshMetaStoragePluginUsername();
            this.password = commonConfiguration.getEventMeshMetaStoragePluginPassword();
            this.dataId = IPUtils.getLocalAddress();
            this.group = commonConfiguration.getMeshGroup();
            break;
        }
        if ((nacosConfig = (NacosMetaStorageConfiguration)(configService = ConfigService.getInstance()).buildConfigInstance(NacosMetaStorageConfiguration.class)) != null) {
            this.nacosConfig = nacosConfig;
        }
    }

    public void start() throws MetaException {
        if (!this.startStatus.compareAndSet(false, true)) {
            return;
        }
        Properties properties = this.buildProperties();
        try {
            this.nacosNamingService = NacosFactory.createNamingService((Properties)properties);
        }
        catch (NacosException e) {
            log.error("[NacosRegistryService][start] error", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        try {
            this.nacosConfigService = NacosFactory.createConfigService((Properties)properties);
        }
        catch (NacosException e) {
            log.error("[NacosConfigService][start] error", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
    }

    private Properties buildProperties() {
        Properties properties = new Properties();
        properties.setProperty("serverAddr", this.serverAddr);
        properties.setProperty("username", this.username);
        properties.setProperty("password", this.password);
        if (this.nacosConfig == null) {
            return properties;
        }
        String endpoint = this.nacosConfig.getEndpoint();
        if (Objects.nonNull(endpoint) && endpoint.contains(":")) {
            int index = endpoint.indexOf(":");
            properties.put("endpoint", endpoint.substring(0, index));
            properties.put("endpointPort", endpoint.substring(index + 1));
        } else {
            Optional.ofNullable(endpoint).ifPresent(value -> properties.put("endpoint", endpoint));
            String endpointPort = this.nacosConfig.getEndpointPort();
            Optional.ofNullable(endpointPort).ifPresent(value -> properties.put("endpointPort", endpointPort));
        }
        String accessKey = this.nacosConfig.getAccessKey();
        Optional.ofNullable(accessKey).ifPresent(value -> properties.put("accessKey", accessKey));
        String secretKey = this.nacosConfig.getSecretKey();
        Optional.ofNullable(secretKey).ifPresent(value -> properties.put("secretKey", secretKey));
        String clusterName = this.nacosConfig.getClusterName();
        Optional.ofNullable(clusterName).ifPresent(value -> properties.put("clusterName", clusterName));
        String logFileName = this.nacosConfig.getLogFileName();
        Optional.ofNullable(logFileName).ifPresent(value -> properties.put("com.alibaba.nacos.naming.log.filename", logFileName));
        String logLevel = this.nacosConfig.getLogLevel();
        Optional.ofNullable(logLevel).ifPresent(value -> properties.put("com.alibaba.nacos.naming.log.level", logLevel));
        Integer pollingThreadCount = this.nacosConfig.getPollingThreadCount();
        Optional.ofNullable(pollingThreadCount).ifPresent(value -> properties.put("namingPollingThreadCount", pollingThreadCount));
        String namespace = this.nacosConfig.getNamespace();
        Optional.ofNullable(namespace).ifPresent(value -> properties.put("namespace", namespace));
        return properties;
    }

    public void getMetaDataWithListener(final MetaServiceListener metaServiceListener, final String key) {
        try {
            this.nacosConfigService.addListener(key, this.group, new Listener(){

                public Executor getExecutor() {
                    return null;
                }

                public void receiveConfigInfo(String configInfo) {
                    metaServiceListener.onChange(key, configInfo);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("add nacos listener for key " + key + "error", e);
        }
    }

    public void shutdown() throws MetaException {
        if (!this.initStatus.compareAndSet(true, false)) {
            return;
        }
        if (!this.startStatus.compareAndSet(true, false)) {
            return;
        }
        try {
            this.nacosNamingService.shutDown();
            log.info("NacosRegistryService close");
        }
        catch (NacosException e) {
            log.error("[NacosRegistryService][shutdown] error", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        try {
            this.nacosConfigService.shutDown();
            log.info("NacosConfigService close");
        }
        catch (NacosException e) {
            log.error("[NacosConfigService][shutdown] error", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws MetaException {
        return this.findEventMeshInfos(true, Collections.singletonList(clusterName));
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws MetaException {
        return this.findEventMeshInfos(false, null);
    }

    private List<EventMeshDataInfo> findEventMeshInfos(boolean inCluster, List<String> clusters) {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration configuration = ConfigurationContextUtil.get((String)key);
            if (Objects.isNull(configuration)) continue;
            String eventMeshName = configuration.getEventMeshName();
            try {
                List instances = this.nacosNamingService.selectInstances(eventMeshName + "-" + key, key + "-" + (inCluster ? configuration.getEventMeshCluster() : "GROUP"), clusters, true);
                if (CollectionUtils.isEmpty((Collection)instances)) continue;
                for (Instance instance : instances) {
                    EventMeshDataInfo eventMeshDataInfo = new EventMeshDataInfo(instance.getClusterName(), instance.getServiceName(), instance.getIp() + ":" + instance.getPort(), 0L, instance.getMetadata());
                    eventMeshDataInfoList.add(eventMeshDataInfo);
                }
            }
            catch (NacosException e) {
                log.error("[NacosRegistryService][findEventMeshInfoByCluster] error", (Throwable)e);
                throw new MetaException(e.getMessage());
            }
        }
        return eventMeshDataInfoList;
    }

    public void registerMetadata(Map<String, String> metadataMap) {
        for (Map.Entry eventMeshRegisterInfo : this.eventMeshRegisterInfoMap.entrySet()) {
            EventMeshRegisterInfo registerInfo = (EventMeshRegisterInfo)eventMeshRegisterInfo.getValue();
            registerInfo.setMetadata(metadataMap);
            this.register(registerInfo);
        }
    }

    public Map<String, String> getMetaData(String key, boolean fuzzyEnabled) {
        Map<String, String> tmpMap;
        if (fuzzyEnabled) {
            key = key + "*";
        }
        int pageNo = 1;
        int pageSize = 100;
        HashMap<String, String> result = new HashMap<String, String>();
        do {
            tmpMap = this.getResultFromNacos(pageNo, pageSize, key, this.group, fuzzyEnabled);
            result.putAll(tmpMap);
        } while (tmpMap.size() >= pageSize);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getResultFromNacos(int pageNo, int pageSize, String key, String group, boolean fuzzyEnabled) {
        Map<String, String> result = new HashMap<String, String>();
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            URIBuilder uriBuilder = new URIBuilder("http://" + this.serverAddr + "/nacos/v1/cs/configs").setParameter("dataId", key).setParameter("group", group).setParameter("pageNo", String.valueOf(pageNo)).setParameter("pageSize", String.valueOf(pageSize));
            if (fuzzyEnabled) {
                uriBuilder.setParameter("search", "blur");
            }
            URI uri = uriBuilder.build();
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("username", this.username);
            httpGet.setHeader("password", this.password);
            try (CloseableHttpResponse closeableHttpResponse = httpclient.execute((HttpUriRequest)httpGet);){
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 200) {
                    String response = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                    result = this.processResponse(response);
                }
            }
            catch (Exception e) {
                log.error("get metaData fail", (Throwable)e);
                throw new RuntimeException(e);
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            log.error("get metaData fail", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> processResponse(String response) {
        HashMap<String, String> result = new HashMap<String, String>();
        JsonNode jsonNode = JacksonUtils.toObj((String)response);
        JsonNode jsonNodeArray = jsonNode.get("pageItems");
        if (jsonNodeArray.isArray()) {
            for (JsonNode js : jsonNodeArray) {
                String key = js.get("dataId").asText();
                String value = js.get("content").asText();
                result.put(key, value);
            }
        }
        return result;
    }

    public void updateMetaData(Map<String, String> metadataMap) {
        String protocol = metadataMap.get("protocol");
        String nacosDataId = this.dataId + "-" + protocol;
        try {
            boolean flag = this.nacosConfigService.publishConfig(nacosDataId, this.group, JacksonUtils.toJson(metadataMap));
            if (flag) {
                log.info("publish metaData {} success", metadataMap);
            } else {
                log.error("publish metaData {} fail", metadataMap);
            }
        }
        catch (NacosException e) {
            log.error("failed to publish data to nacos", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void removeMetaData(String key) {
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws MetaException {
        try {
            String[] ipPort = eventMeshRegisterInfo.getEndPoint().split(":");
            if (ipPort.length < 2) {
                return false;
            }
            String eventMeshClusterName = eventMeshRegisterInfo.getEventMeshClusterName();
            Map metadata = eventMeshRegisterInfo.getMetadata();
            Instance instance = new Instance();
            instance.setIp(ipPort[0]);
            instance.setPort(Integer.parseInt(ipPort[1]));
            instance.setWeight(1.0);
            instance.setClusterName(eventMeshClusterName);
            instance.setMetadata(metadata);
            String eventMeshName = eventMeshRegisterInfo.getEventMeshName();
            this.nacosNamingService.registerInstance(eventMeshName, eventMeshRegisterInfo.getProtocolType() + "-" + "GROUP", instance);
            this.eventMeshRegisterInfoMap.put(eventMeshName, eventMeshRegisterInfo);
        }
        catch (NacosException e) {
            log.error("[NacosRegistryService][register] error", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        log.info("EventMesh successfully registered to nacos");
        return true;
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws MetaException {
        String[] ipPort = eventMeshUnRegisterInfo.getEndPoint().split(":");
        try {
            Instance instance = new Instance();
            instance.setIp(ipPort[0]);
            instance.setPort(Integer.parseInt(ipPort[1]));
            String eventMeshName = eventMeshUnRegisterInfo.getEventMeshName();
            String eventMeshClusterName = eventMeshUnRegisterInfo.getEventMeshClusterName();
            instance.setClusterName(eventMeshClusterName);
            this.nacosNamingService.deregisterInstance(eventMeshName, eventMeshUnRegisterInfo.getProtocolType() + "-" + "GROUP", instance);
            this.eventMeshRegisterInfoMap.remove(eventMeshName);
        }
        catch (NacosException e) {
            log.error("[NacosRegistryService][unRegister] error", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        log.info("EventMesh successfully logout to nacos");
        return true;
    }

    @Generated
    public String getServerAddr() {
        return this.serverAddr;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public NacosMetaStorageConfiguration getNacosConfig() {
        return this.nacosConfig;
    }

    @Generated
    public NamingService getNacosNamingService() {
        return this.nacosNamingService;
    }
}

