/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableConcatIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableConcatIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver s) {
        Iterator<? extends CompletableSource> it;
        try {
            it = ObjectHelper.requireNonNull(this.sources.iterator(), "The iterator returned is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, s);
            return;
        }
        ConcatInnerObserver inner = new ConcatInnerObserver(s, it);
        s.onSubscribe(inner.sd);
        inner.next();
    }

    static final class ConcatInnerObserver
    extends AtomicInteger
    implements CompletableObserver {
        private static final long serialVersionUID = -7965400327305809232L;
        final CompletableObserver actual;
        final Iterator<? extends CompletableSource> sources;
        final SequentialDisposable sd;

        ConcatInnerObserver(CompletableObserver actual, Iterator<? extends CompletableSource> sources) {
            this.actual = actual;
            this.sources = sources;
            this.sd = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.sd.update(d);
        }

        @Override
        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        @Override
        public void onComplete() {
            this.next();
        }

        void next() {
            if (this.sd.isDisposed()) {
                return;
            }
            if (this.getAndIncrement() != 0) {
                return;
            }
            Iterator<? extends CompletableSource> a = this.sources;
            do {
                CompletableSource c;
                boolean b;
                if (this.sd.isDisposed()) {
                    return;
                }
                try {
                    b = a.hasNext();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.actual.onError(ex);
                    return;
                }
                if (!b) {
                    this.actual.onComplete();
                    return;
                }
                try {
                    c = ObjectHelper.requireNonNull(a.next(), "The CompletableSource returned is null");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.actual.onError(ex);
                    return;
                }
                c.subscribe(this);
            } while (this.decrementAndGet() != 0);
        }
    }
}

