/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.util;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.loadbalance.LoadBalanceSelector;
import org.apache.eventmesh.common.loadbalance.RandomLoadBalanceSelector;
import org.apache.eventmesh.common.loadbalance.Weight;
import org.apache.eventmesh.common.loadbalance.WeightRandomLoadBalanceSelector;
import org.apache.eventmesh.common.loadbalance.WeightRoundRobinLoadBalanceSelector;

public class HttpLoadBalanceUtils {
    private static final Pattern IP_PORT_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}:\\d{4,5}");
    private static final Pattern IP_PORT_WEIGHT_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}:\\d{4,5}:\\d{1,6}");

    public static LoadBalanceSelector<String> createEventMeshServerLoadBalanceSelector(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        RandomLoadBalanceSelector eventMeshServerSelector = null;
        switch (eventMeshHttpClientConfig.getLoadBalanceType()) {
            case RANDOM: {
                eventMeshServerSelector = new RandomLoadBalanceSelector(HttpLoadBalanceUtils.buildClusterGroupFromConfig(eventMeshHttpClientConfig));
                break;
            }
            case WEIGHT_RANDOM: {
                eventMeshServerSelector = new WeightRandomLoadBalanceSelector(HttpLoadBalanceUtils.buildWeightedClusterGroupFromConfig(eventMeshHttpClientConfig));
                break;
            }
            case WEIGHT_ROUND_ROBIN: {
                eventMeshServerSelector = new WeightRoundRobinLoadBalanceSelector(HttpLoadBalanceUtils.buildWeightedClusterGroupFromConfig(eventMeshHttpClientConfig));
                break;
            }
        }
        if (eventMeshServerSelector == null) {
            throw new EventMeshException("liteEventMeshAddr param illegal,please check");
        }
        return eventMeshServerSelector;
    }

    private static List<Weight<String>> buildWeightedClusterGroupFromConfig(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        List eventMeshAddrs = Splitter.on((String)";").trimResults().splitToList((CharSequence)eventMeshHttpClientConfig.getLiteEventMeshAddr());
        if (CollectionUtils.isEmpty((Collection)eventMeshAddrs)) {
            throw new EventMeshException("liteEventMeshAddr can not be empty");
        }
        ArrayList<Weight<String>> eventMeshAddrWeightList = new ArrayList<Weight<String>>();
        for (String eventMeshAddrWight : eventMeshAddrs) {
            if (!IP_PORT_WEIGHT_PATTERN.matcher(eventMeshAddrWight).matches()) {
                throw new EventMeshException(String.format("liteEventMeshAddr:%s is not illegal", eventMeshHttpClientConfig.getLiteEventMeshAddr()));
            }
            int splitIndex = eventMeshAddrWight.lastIndexOf(":");
            Weight weight = new Weight((Object)eventMeshAddrWight.substring(0, splitIndex), Integer.parseInt(eventMeshAddrWight.substring(splitIndex + 1)));
            eventMeshAddrWeightList.add((Weight<String>)weight);
        }
        return eventMeshAddrWeightList;
    }

    private static List<String> buildClusterGroupFromConfig(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        List eventMeshAddrs = Splitter.on((String)";").trimResults().splitToList((CharSequence)eventMeshHttpClientConfig.getLiteEventMeshAddr());
        if (CollectionUtils.isEmpty((Collection)eventMeshAddrs)) {
            throw new EventMeshException("liteEventMeshAddr can not be empty");
        }
        ArrayList<String> eventMeshAddrList = new ArrayList<String>();
        for (String eventMeshAddr : eventMeshAddrs) {
            if (!IP_PORT_PATTERN.matcher(eventMeshAddr).matches()) {
                throw new EventMeshException(String.format("liteEventMeshAddr:%s is not illegal", eventMeshHttpClientConfig.getLiteEventMeshAddr()));
            }
            eventMeshAddrList.add(eventMeshAddr);
        }
        return eventMeshAddrList;
    }
}

