/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.api.RFuture;
import org.redisson.connection.ServiceManager;

public class ProxyBuilder {
    private static final ConcurrentMap<CacheKey, Method> METHODS_MAPPING = new ConcurrentHashMap<CacheKey, Method>();

    public static <T> T create(final Callback commandExecutor, final Object instance, final Object implementation, Class<T> clazz, ServiceManager serviceManager) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method instanceMethod = ProxyBuilder.getMethod(method, instance, implementation);
                if (instanceMethod.getName().endsWith("Async")) {
                    Callable<RFuture<Object>> callable = () -> (RFuture)instanceMethod.invoke(instance, args);
                    return commandExecutor.execute(callable, method);
                }
                if (implementation != null && instanceMethod.getDeclaringClass().isAssignableFrom(implementation.getClass())) {
                    return instanceMethod.invoke(implementation, args);
                }
                return instanceMethod.invoke(instance, args);
            }
        };
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
    }

    private static Method getMethod(Method method, Object instance, Object implementation) throws NoSuchMethodException {
        CacheKey key = new CacheKey(method, instance.getClass());
        Method instanceMethod = (Method)METHODS_MAPPING.get(key);
        if (instanceMethod == null) {
            if (implementation != null) {
                try {
                    instanceMethod = implementation.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    try {
                        instanceMethod = instance.getClass().getMethod(method.getName() + "Async", method.getParameterTypes());
                    }
                    catch (Exception e2) {
                        instanceMethod = instance.getClass().getMethod(method.getName(), method.getParameterTypes());
                    }
                }
            } else {
                try {
                    instanceMethod = instance.getClass().getMethod(method.getName() + "Async", method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    instanceMethod = instance.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
            }
            METHODS_MAPPING.put(key, instanceMethod);
        }
        return instanceMethod;
    }

    public static interface Callback {
        public Object execute(Callable<RFuture<Object>> var1, Method var2);
    }

    private static class CacheKey {
        final Method method;
        final Class<?> instanceClass;

        CacheKey(Method method, Class<?> instanceClass) {
            this.method = method;
            this.instanceClass = instanceClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.method.equals(cacheKey.method) && this.instanceClass.equals(cacheKey.instanceClass);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.instanceClass);
        }
    }
}

