/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.middleware.builtin;

import com.slack.api.app_backend.SlackSignature;
import com.slack.api.bolt.middleware.Middleware;
import com.slack.api.bolt.middleware.MiddlewareChain;
import com.slack.api.bolt.middleware.MiddlewareOps;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.response.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestVerification
implements Middleware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestVerification.class);
    private final SlackSignature.Verifier verifier;

    public RequestVerification(SlackSignature.Verifier verifier) {
        this.verifier = verifier;
    }

    @Override
    public Response apply(Request req, Response resp, MiddlewareChain chain) throws Exception {
        if (req.isSocketMode() || MiddlewareOps.isNoSlackSignatureRequest(req.getRequestType())) {
            return chain.next(req);
        }
        if (req.isValid(this.verifier)) {
            return chain.next(req);
        }
        String signature = req.getHeaders().getFirstValue("X-Slack-Signature");
        log.info("Invalid signature detected - {}", (Object)signature);
        return Response.json(401, "{\"error\":\"invalid request\"}");
    }
}

