/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestContext.class);
    private Object key;
    private Package request;
    private final CompletableFuture<Package> future = new CompletableFuture();

    public RequestContext(Object key, Package request) {
        this.key = key;
        this.request = request;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Package getRequest() {
        return this.request;
    }

    public void setRequest(Package request) {
        this.request = request;
    }

    public CompletableFuture<Package> future() {
        return this.future;
    }

    public Package getResponse(long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        return this.future.get(timeout, timeUnit);
    }

    public Package getResponse(long timeout) throws ExecutionException, InterruptedException, TimeoutException {
        return this.future.get(timeout, TimeUnit.MILLISECONDS);
    }

    public void finish(Package msg) {
        this.future.complete(msg);
    }

    public static RequestContext context(Object key, Package request) throws Exception {
        RequestContext context = new RequestContext(key, request);
        log.info("_RequestContext|create|key={}", key);
        return context;
    }

    public static Object key(Package request) {
        return request.getHeader().getSeq();
    }
}

