/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.impl;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.common.RequestContext;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventMeshTCPPubHandler<ProtocolMessage>
extends SimpleChannelInboundHandler<Package> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractEventMeshTCPPubHandler.class);
    private final ConcurrentHashMap<Object, RequestContext> contexts;

    public AbstractEventMeshTCPPubHandler(ConcurrentHashMap<Object, RequestContext> contexts) {
        this.contexts = contexts;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Package msg) {
        log.info("SimplePubClientImpl|receive|msg={}", (Object)msg);
        Preconditions.checkNotNull((Object)msg.getHeader(), (Object)"Tcp package header cannot be null");
        Command cmd = msg.getHeader().getCmd();
        switch (cmd) {
            case RESPONSE_TO_CLIENT: {
                this.callback(this.getMessage(msg), ctx);
                this.sendResponse(MessageUtils.responseToClientAck(msg));
                break;
            }
            case SERVER_GOODBYE_REQUEST: {
                break;
            }
        }
        RequestContext context = this.contexts.get(RequestContext.key(msg));
        if (context != null) {
            this.contexts.remove(context.getKey());
            context.finish(msg);
        }
    }

    public abstract void callback(ProtocolMessage var1, ChannelHandlerContext var2);

    public abstract ProtocolMessage getMessage(Package var1);

    public abstract void sendResponse(Package var1);
}

