/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCloneTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLExternalRecordFormat;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLObjectType;
import com.alibaba.druid.sql.ast.statement.SQLPrivilegeItem;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowACLStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowFunctionsStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowHistoryStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowPackagesStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowPartitionsStmt;
import com.alibaba.druid.sql.ast.statement.SQLShowRecylebinStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowRoleStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowRolesStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowStatisticListStmt;
import com.alibaba.druid.sql.ast.statement.SQLShowStatisticStmt;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowUsersStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLWhoamiStatement;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveCreateFunctionStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveLoadDataStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlKillStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAddAccountProviderStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAddFileStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAddStatisticStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAddTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAddUserStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsCopyStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsCountStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsDeclareVariableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsExstoreStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsGrantStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsInstallPackageStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsListStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsPAIStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsQueryAliasStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsReadStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsRemoveStatisticStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsRemoveUserStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsRestoreStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSetLabelStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowChangelogsStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowGrantsStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsStatisticClause;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsUndoTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsUnloadStatement;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsCreateTableParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class OdpsStatementParser
extends SQLStatementParser {
    public OdpsStatementParser(String sql) {
        super(new OdpsExprParser(sql, new SQLParserFeature[0]));
    }

    public OdpsStatementParser(String sql, SQLParserFeature ... features) {
        super(new OdpsExprParser(sql, features));
    }

    public OdpsStatementParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLSelectStatement parseSelect() {
        SQLSelect select = new OdpsSelectParser(this.exprParser).select();
        return new SQLSelectStatement(select, DbType.odps);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        OdpsCreateTableParser parser = new OdpsCreateTableParser(this.exprParser);
        return parser.parseCreateTable();
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new OdpsCreateTableParser(this.exprParser);
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.FROM) {
            SQLStatement stmt = this.parseInsert();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("ANALYZE")) {
            SQLStatement stmt = this.parseAnalyze();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("ADD")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("STATISTIC")) {
                this.lexer.nextToken();
                OdpsAddStatisticStatement stmt = new OdpsAddStatisticStatement();
                stmt.setTable(this.exprParser.name());
                stmt.setStatisticClause(this.parseStaticClause());
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                OdpsAddUserStatement stmt = new OdpsAddUserStatement();
                stmt.setUser(this.exprParser.name());
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.identifierEquals("ACCOUNTPROVIDER")) {
                this.lexer.nextToken();
                OdpsAddAccountProviderStatement stmt = new OdpsAddAccountProviderStatement();
                stmt.setProvider(this.exprParser.name());
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                OdpsAddTableStatement stmt = new OdpsAddTableStatement();
                stmt.setTable(this.exprParser.name());
                if (this.lexer.token() == Token.PARTITION) {
                    this.lexer.nextToken();
                    this.exprParser.parseAssignItem(stmt.getPartitions(), (SQLObject)stmt);
                }
                if (this.lexer.token() == Token.AS) {
                    this.lexer.nextToken();
                    SQLName name = this.exprParser.name();
                    stmt.getTable().setAlias(name.toString());
                }
                if (this.lexer.token() == Token.COMMENT) {
                    this.lexer.nextToken();
                    stmt.setComment(this.exprParser.primary());
                }
                if (this.lexer.token() == Token.SUB) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("f");
                    stmt.setForce(true);
                }
                if (this.lexer.token() == Token.TO) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("PACKAGE");
                    SQLName packageName = this.exprParser.name();
                    stmt.setToPackage(packageName);
                    if (this.lexer.token() == Token.WITH) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("PRIVILEGES");
                        this.parsePrivileages(stmt.getPrivileges(), stmt);
                    }
                }
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.FILE) || this.lexer.identifierEquals(FnvHash.Constants.JAR) || this.lexer.identifierEquals(FnvHash.Constants.PY) || this.lexer.identifierEquals(FnvHash.Constants.ARCHIVE)) {
                OdpsAddFileStatement stmt = new OdpsAddFileStatement();
                long hash = this.lexer.hashLCase();
                if (hash == FnvHash.Constants.JAR) {
                    stmt.setType(OdpsAddFileStatement.FileType.JAR);
                } else if (hash == FnvHash.Constants.PY) {
                    stmt.setType(OdpsAddFileStatement.FileType.PY);
                } else if (hash == FnvHash.Constants.ARCHIVE) {
                    stmt.setType(OdpsAddFileStatement.FileType.ARCHIVE);
                }
                this.lexer.nextPath();
                String path = this.lexer.stringVal();
                this.lexer.nextToken();
                stmt.setFile(path);
                if (this.lexer.token() == Token.AS) {
                    this.lexer.nextToken();
                    SQLName name = this.exprParser.name();
                    stmt.setAlias(name.toString());
                }
                if (this.lexer.token() == Token.COMMENT) {
                    this.lexer.nextToken();
                    stmt.setComment(this.exprParser.primary());
                }
                if (this.lexer.token() == Token.SUB) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("f");
                    stmt.setForce(true);
                }
                statementList.add(stmt);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals("REMOVE")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("STATISTIC")) {
                this.lexer.nextToken();
                OdpsRemoveStatisticStatement stmt = new OdpsRemoveStatisticStatement();
                stmt.setTable(this.exprParser.name());
                stmt.setStatisticClause(this.parseStaticClause());
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                OdpsRemoveUserStatement stmt = new OdpsRemoveUserStatement();
                stmt.setUser((SQLIdentifierExpr)this.exprParser.name());
                statementList.add(stmt);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals("READ")) {
            OdpsReadStatement stmt = new OdpsReadStatement();
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                stmt.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.lexer.nextToken();
            stmt.setTable(this.exprParser.name());
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(stmt.getColumns(), stmt);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getPartition(), stmt);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.LITERAL_INT) {
                stmt.setRowCount(this.exprParser.primary());
            }
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("LIST")) {
            OdpsListStmt stmt = new OdpsListStmt();
            this.lexer.nextToken();
            stmt.setObject(this.exprParser.expr());
            if (this.lexer.identifierEquals("ROLES") && stmt.getObject() instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)stmt.getObject()).nameEquals("TENANT")) {
                this.lexer.nextToken();
                stmt.setObject(new SQLIdentifierExpr("TENANT ROLES"));
            } else if (this.lexer.identifierEquals("OUTPUT") && stmt.getObject() instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)stmt.getObject()).nameEquals("TEMPORARY")) {
                this.lexer.nextToken();
                stmt.setObject(new SQLIdentifierExpr("TEMPORARY OUTPUT"));
            }
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.DESC || this.lexer.identifierEquals("DESCRIBE")) {
            SQLStatement stmt = this.parseDescribe();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("WHOAMI")) {
            this.lexer.nextToken();
            SQLWhoamiStatement stmt = new SQLWhoamiStatement();
            stmt.setDbType(DbType.odps);
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("COUNT")) {
            this.lexer.nextToken();
            OdpsCountStatement stmt = new OdpsCountStatement();
            stmt.setTable(this.exprParser.name());
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.exprParser.parseAssignItem(stmt.getPartitions(), (SQLObject)stmt);
            }
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("MSCK")) {
            SQLStatement stmt = this.parseMsck();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("alias")) {
            SQLStatement stmt = this.parseSet();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("EXSTORE")) {
            this.lexer.nextToken();
            OdpsExstoreStatement stmt = new OdpsExstoreStatement();
            SQLExpr table = this.exprParser.expr();
            stmt.setTable(new SQLExprTableSource(table));
            this.accept(Token.PARTITION);
            this.exprParser.parseAssignItem(stmt.getPartitions(), (SQLObject)stmt);
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("INSTALL")) {
            this.lexer.nextToken();
            this.acceptIdentifier("PACKAGE");
            OdpsInstallPackageStatement stmt = new OdpsInstallPackageStatement();
            stmt.setPackageName(this.exprParser.name());
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("PAI")) {
            String arguments;
            char next;
            this.lexer.nextToken();
            int semiPos = this.lexer.text.indexOf(59, this.lexer.pos());
            while (semiPos != -1 && semiPos + 2 < this.lexer.text.length() && ((next = this.lexer.text.charAt(semiPos + 1)) == '\"' || next == '\'')) {
                semiPos = this.lexer.text.indexOf(59, semiPos + 1);
            }
            if (semiPos != -1) {
                int count = semiPos - this.lexer.pos();
                arguments = this.lexer.subString(this.lexer.pos(), count);
                this.lexer.reset(semiPos);
            } else {
                arguments = this.lexer.subString(this.lexer.pos());
                this.lexer.reset(this.lexer.text.length());
            }
            this.lexer.nextToken();
            OdpsPAIStmt stmt = new OdpsPAIStmt();
            stmt.setArguments(arguments);
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("COPY")) {
            SQLStatement stmt = this.parseCopy();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.KILL)) {
            SQLStatement stmt = this.parseKill();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOAD)) {
            HiveLoadDataStatement stmt = this.parseLoad();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.MERGE)) {
            SQLStatement stmt = this.parseMerge();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CLONE)) {
            SQLStatement stmt = this.parseClone();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.UNLOAD)) {
            SQLStatement stmt = this.parseUnload();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.BEGIN)) {
            SQLStatement stmt = this.parseBlock();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RESTORE)) {
            this.lexer.nextToken();
            this.accept(Token.TABLE);
            OdpsRestoreStatement stmt = new OdpsRestoreStatement();
            stmt.setTable(this.exprParser.name());
            if (this.lexer.token() == Token.LPAREN) {
                this.exprParser.parseAssignItem(stmt.getProperties(), (SQLObject)stmt);
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.exprParser.parseAssignItem(stmt.getPartitions(), (SQLObject)stmt);
            }
            if (this.lexer.token() == Token.TO) {
                this.lexer.nextToken();
                this.acceptIdentifier("LSN");
                stmt.setTo(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
                stmt.setAlias(this.alias());
            }
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.UNDO)) {
            this.lexer.nextToken();
            this.accept(Token.TABLE);
            OdpsUndoTableStatement stmt = new OdpsUndoTableStatement();
            stmt.setTable(new SQLExprTableSource(this.exprParser.name()));
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.exprParser.parseAssignItem(stmt.getPartitions(), (SQLObject)stmt);
            }
            this.accept(Token.TO);
            stmt.setTo(this.exprParser.expr());
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.FUNCTION) {
            HiveCreateFunctionStatement stmt = (HiveCreateFunctionStatement)this.parseHiveCreateFunction();
            stmt.setDeclare(true);
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.VARIANT && this.lexer.stringVal().startsWith("@")) {
            Lexer.SavePoint mark = this.lexer.mark();
            String variant = this.lexer.stringVal();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.COLONEQ) {
                SQLSelect select;
                this.lexer.nextToken();
                boolean cache = false;
                if (this.lexer.identifierEquals(FnvHash.Constants.CACHE)) {
                    this.lexer.nextToken();
                    this.accept(Token.ON);
                    cache = true;
                }
                Lexer.SavePoint lpMark = null;
                if (this.lexer.token() == Token.LPAREN) {
                    lpMark = this.lexer.mark();
                    this.lexer.nextToken();
                }
                switch (this.lexer.token()) {
                    case LITERAL_INT: 
                    case LITERAL_FLOAT: 
                    case LITERAL_CHARS: 
                    case LITERAL_ALIAS: 
                    case IDENTIFIER: 
                    case CASE: 
                    case CAST: 
                    case IF: 
                    case VARIANT: 
                    case REPLACE: 
                    case NEW: 
                    case SUB: 
                    case TRUE: 
                    case FALSE: {
                        if (lpMark != null) {
                            this.lexer.reset(lpMark);
                        }
                        SQLExpr expr = this.exprParser.expr();
                        SQLExprStatement stmt = new SQLExprStatement(new SQLAssignItem(new SQLIdentifierExpr(variant), expr));
                        statementList.add(stmt);
                        return true;
                    }
                }
                if (lpMark != null) {
                    this.lexer.reset(lpMark);
                }
                boolean paren = this.lexer.token() == Token.LPAREN;
                Lexer.SavePoint parenMark = this.lexer.mark();
                try {
                    select = new OdpsSelectParser(this.exprParser).select();
                }
                catch (ParserException error) {
                    if (paren) {
                        this.lexer.reset(parenMark);
                        SQLExpr expr = this.exprParser.expr();
                        SQLExprStatement stmt = new SQLExprStatement(new SQLAssignItem(new SQLIdentifierExpr(variant), expr));
                        statementList.add(stmt);
                        return true;
                    }
                    throw error;
                }
                switch (this.lexer.token()) {
                    case GT: 
                    case GTEQ: 
                    case EQ: 
                    case LT: 
                    case LTEQ: {
                        statementList.add(new SQLExprStatement(new SQLAssignItem(new SQLIdentifierExpr(variant), this.exprParser.exprRest(new SQLQueryExpr(select)))));
                        return true;
                    }
                }
                SQLSelectStatement stmt = new SQLSelectStatement(select, this.dbType);
                OdpsQueryAliasStatement aliasQueryStatement = new OdpsQueryAliasStatement(variant, stmt);
                aliasQueryStatement.setCache(cache);
                statementList.add(aliasQueryStatement);
                return true;
            }
            OdpsDeclareVariableStatement stmt = new OdpsDeclareVariableStatement();
            if (this.lexer.token() != Token.EQ && this.lexer.token() != Token.SEMI && this.lexer.token() != Token.EOF) {
                stmt.setDataType(this.exprParser.parseDataType());
            }
            if (this.lexer.token() == Token.EQ || this.lexer.token() == Token.COLONEQ) {
                this.lexer.nextToken();
                stmt.setInitValue(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.SEMI) {
                this.lexer.nextToken();
            }
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.IF) {
            SQLStatement stmt = this.parseIf();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.CODE) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EOF || this.lexer.token() == Token.SEMI) {
                return true;
            }
            this.lexer.reset(mark);
        }
        return false;
    }

    @Override
    public SQLStatement parseIf() {
        this.accept(Token.IF);
        SQLIfStatement ifStmt = new SQLIfStatement();
        ifStmt.setCondition(this.exprParser.expr());
        if (this.lexer.identifierEquals("BEGIN")) {
            this.lexer.nextToken();
            this.parseStatementList(ifStmt.getStatements(), -1, ifStmt);
            this.accept(Token.END);
        } else {
            SQLStatement stmt = this.parseStatement();
            ifStmt.getStatements().add(stmt);
            stmt.setParent(ifStmt);
        }
        if (this.lexer.token() == Token.SEMI) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.ELSE) {
            this.lexer.nextToken();
            SQLIfStatement.Else elseItem = new SQLIfStatement.Else();
            if (this.lexer.identifierEquals("BEGIN")) {
                this.lexer.nextToken();
                this.parseStatementList(elseItem.getStatements(), -1, ifStmt);
                this.accept(Token.END);
            } else {
                SQLStatement stmt = this.parseStatement();
                elseItem.getStatements().add(stmt);
                stmt.setParent(elseItem);
            }
            ifStmt.setElseItem(elseItem);
        }
        return ifStmt;
    }

    @Override
    public SQLStatement parseKill() {
        this.acceptIdentifier("KILL");
        MySqlKillStatement stmt = new MySqlKillStatement();
        SQLExpr instanceId = this.exprParser.primary();
        stmt.setThreadId(instanceId);
        return stmt;
    }

    public SQLStatement parseUnload() {
        this.acceptIdentifier("UNLOAD");
        OdpsUnloadStatement stmt = new OdpsUnloadStatement();
        this.accept(Token.FROM);
        if (this.lexer.token() == Token.LPAREN || this.lexer.token() == Token.SELECT) {
            stmt.setFrom(this.createSQLSelectParser().parseTableSource());
        } else {
            stmt.setFrom(this.exprParser.name());
        }
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.exprParser.parseAssignItem(stmt.getPartitions(), (SQLObject)stmt);
        }
        this.accept(Token.INTO);
        if (this.lexer.identifierEquals("LOCATION")) {
            this.lexer.nextToken();
            stmt.setLocation(this.exprParser.primary());
        }
        if (this.lexer.identifierEquals("ROW")) {
            SQLExternalRecordFormat format = this.exprParser.parseRowFormat();
            stmt.setRowFormat(format);
        }
        while (true) {
            if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.BY) {
                    this.lexer.nextToken();
                } else {
                    this.accept(Token.AS);
                }
                stmt.setStoredAs(this.exprParser.name());
                continue;
            }
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                this.acceptIdentifier("SERDEPROPERTIES");
                this.exprParser.parseAssignItem(stmt.getSerdeProperties(), (SQLObject)stmt);
                continue;
            }
            if (!this.identifierEquals("PROPERTIES")) break;
            this.lexer.nextToken();
            this.exprParser.parseAssignItem(stmt.getProperties(), (SQLObject)stmt);
        }
        return stmt;
    }

    @Override
    public SQLStatement parseClone() {
        this.acceptIdentifier("CLONE");
        this.accept(Token.TABLE);
        SQLCloneTableStatement stmt = new SQLCloneTableStatement();
        stmt.setFrom(this.exprParser.name());
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.exprParser.parseAssignItem(stmt.getPartitions(), (SQLObject)stmt);
        }
        this.accept(Token.TO);
        stmt.setTo(this.exprParser.name());
        if (this.lexer.token() == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            if (this.lexer.token() == Token.OVERWRITE) {
                this.lexer.nextToken();
                stmt.setIfExistsOverwrite(true);
            } else {
                this.acceptIdentifier("IGNORE");
                stmt.setIfExistsIgnore(true);
            }
        }
        return stmt;
    }

    @Override
    public SQLStatement parseBlock() {
        SQLBlockStatement block = new SQLBlockStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.BEGIN)) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.BEGIN);
        }
        this.parseStatementList(block.getStatementList(), -1, block);
        this.accept(Token.END);
        return block;
    }

    protected OdpsStatisticClause parseStaticClause() {
        if (this.lexer.identifierEquals("TABLE_COUNT")) {
            this.lexer.nextToken();
            return new OdpsStatisticClause.TableCount();
        }
        if (this.lexer.identifierEquals("NULL_VALUE")) {
            this.lexer.nextToken();
            OdpsStatisticClause.NullValue null_value = new OdpsStatisticClause.NullValue();
            null_value.setColumn(this.exprParser.name());
            return null_value;
        }
        if (this.lexer.identifierEquals("DISTINCT_VALUE")) {
            this.lexer.nextToken();
            OdpsStatisticClause.DistinctValue distinctValue = new OdpsStatisticClause.DistinctValue();
            distinctValue.setColumn(this.exprParser.name());
            return distinctValue;
        }
        if (this.lexer.identifierEquals("COLUMN_SUM")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnSum column_sum = new OdpsStatisticClause.ColumnSum();
            column_sum.setColumn(this.exprParser.name());
            return column_sum;
        }
        if (this.lexer.identifierEquals("COLUMN_MAX")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnMax column_max = new OdpsStatisticClause.ColumnMax();
            column_max.setColumn(this.exprParser.name());
            return column_max;
        }
        if (this.lexer.identifierEquals("COLUMN_MIN")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ColumnMin column_min = new OdpsStatisticClause.ColumnMin();
            column_min.setColumn(this.exprParser.name());
            return column_min;
        }
        if (this.lexer.identifierEquals("EXPRESSION_CONDITION")) {
            this.lexer.nextToken();
            OdpsStatisticClause.ExpressionCondition expr_condition = new OdpsStatisticClause.ExpressionCondition();
            expr_condition.setExpr(this.exprParser.expr());
            return expr_condition;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    public SQLStatement parseInsert() {
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            HiveMultiInsertStatement stmt = new HiveMultiInsertStatement();
            if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.VARIANT) {
                Lexer.SavePoint mark = this.lexer.mark();
                SQLExpr tableName = this.exprParser.name();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.reset(mark);
                    tableName = this.exprParser.primary();
                }
                SQLTableSource from = new SQLExprTableSource(tableName);
                if (this.lexer.token() == Token.IDENTIFIER) {
                    String alias = this.alias();
                    from.setAlias(alias);
                }
                SQLSelectParser selectParser = this.createSQLSelectParser();
                from = selectParser.parseTableSourceRest(from);
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    SQLExpr where = this.exprParser.expr();
                    SQLSelectQueryBlock queryBlock = new SQLSelectQueryBlock();
                    queryBlock.addSelectItem(new SQLAllColumnExpr());
                    queryBlock.setFrom(from);
                    queryBlock.setWhere(where);
                    if (this.lexer.token() == Token.GROUP) {
                        selectParser.parseGroupBy(queryBlock);
                    }
                    stmt.setFrom(new SQLSubqueryTableSource(queryBlock));
                } else {
                    stmt.setFrom(from);
                }
            } else {
                String alias;
                SQLCommentHint hint = null;
                if (this.lexer.token() == Token.HINT) {
                    hint = this.exprParser.parseHint();
                }
                this.accept(Token.LPAREN);
                boolean paren2 = this.lexer.token() == Token.LPAREN;
                SQLSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                SQLTableSource from = null;
                if (paren2 && this.lexer.token() != Token.RPAREN) {
                    String subQueryAs = null;
                    if (this.lexer.token() == Token.AS) {
                        this.lexer.nextToken();
                        subQueryAs = this.tableAlias(true);
                    } else {
                        subQueryAs = this.tableAlias(false);
                    }
                    SQLSubqueryTableSource subQuery = new SQLSubqueryTableSource(select, subQueryAs);
                    from = selectParser.parseTableSourceRest(subQuery);
                }
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.INSERT) {
                    alias = null;
                } else if (this.lexer.token() == Token.SELECT) {
                    alias = null;
                } else {
                    if (this.lexer.token() == Token.AS) {
                        this.lexer.nextToken();
                    }
                    alias = this.lexer.stringVal();
                    this.accept(Token.IDENTIFIER);
                }
                if (from == null) {
                    from = new SQLSubqueryTableSource(select, alias);
                } else if (alias != null) {
                    from.setAlias(alias);
                }
                SQLTableSource tableSource = selectParser.parseTableSourceRest(from);
                if (hint != null && tableSource instanceof SQLJoinTableSource) {
                    ((SQLJoinTableSource)tableSource).setHint(hint);
                }
                stmt.setFrom(tableSource);
            }
            if (this.lexer.token() == Token.SELECT) {
                SQLSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect query = selectParser.select();
                HiveInsert insert = new HiveInsert();
                insert.setQuery(query);
                stmt.addItem(insert);
                return stmt;
            }
            do {
                HiveInsert insert = this.parseHiveInsert();
                stmt.addItem(insert);
            } while (this.lexer.token() == Token.INSERT);
            return stmt;
        }
        return this.parseHiveInsertStmt();
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new OdpsSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLStatement parseShow() {
        this.accept(Token.SHOW);
        if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
            this.lexer.nextToken();
            SQLShowPartitionsStmt stmt = new SQLShowPartitionsStmt();
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getPartition(), stmt, false);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STATISTIC)) {
            this.lexer.nextToken();
            SQLShowStatisticStmt stmt = new SQLShowStatisticStmt();
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getPartitions(), stmt, false);
                this.accept(Token.RPAREN);
            }
            if (this.identifierEquals("COLUMNS")) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.SEMI) {
                    this.accept(Token.LPAREN);
                    this.exprParser.names(stmt.getColumns(), stmt);
                    this.accept(Token.RPAREN);
                }
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STATISTIC_LIST)) {
            this.lexer.nextToken();
            SQLShowStatisticListStmt stmt = new SQLShowStatisticListStmt();
            SQLExpr expr = this.exprParser.expr();
            stmt.setTableSource(new SQLExprTableSource(expr));
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PACKAGES)) {
            this.lexer.nextToken();
            SQLShowPackagesStatement stmt = new SQLShowPackagesStatement();
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
            this.lexer.nextToken();
            SQLShowTablesStatement stmt = new SQLShowTablesStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setDatabase(this.exprParser.name());
            } else if (this.lexer.token() == Token.IDENTIFIER) {
                SQLName database = this.exprParser.name();
                stmt.setDatabase(database);
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            } else if (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.LITERAL_ALIAS) {
                stmt.setLike(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LABEL)) {
            this.lexer.nextToken();
            this.acceptIdentifier("GRANTS");
            OdpsShowGrantsStmt stmt = new OdpsShowGrantsStmt();
            stmt.setLabel(true);
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                this.accept(Token.TABLE);
                stmt.setObjectType(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                this.accept(Token.USER);
                stmt.setUser(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.GRANTS)) {
            this.lexer.nextToken();
            OdpsShowGrantsStmt stmt = new OdpsShowGrantsStmt();
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.USER) {
                    this.lexer.nextToken();
                }
                stmt.setUser(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                this.acceptIdentifier("type");
                stmt.setObjectType(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.USERS)) {
            this.lexer.nextToken();
            SQLShowUsersStatement stmt = new SQLShowUsersStatement();
            return stmt;
        }
        if (this.lexer.identifierEquals("RECYCLEBIN")) {
            this.lexer.nextToken();
            SQLShowRecylebinStatement stmt = new SQLShowRecylebinStatement();
            return stmt;
        }
        if (this.lexer.identifierEquals("VARIABLES")) {
            this.lexer.nextToken();
            return this.parseShowVariants();
        }
        if (this.lexer.token() == Token.CREATE) {
            return this.parseShowCreateTable();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.FUNCTIONS)) {
            this.lexer.nextToken();
            SQLShowFunctionsStatement stmt = new SQLShowFunctionsStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            } else if (this.lexer.token() == Token.LITERAL_CHARS || this.lexer.token() == Token.IDENTIFIER) {
                stmt.setLike(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ROLE)) {
            this.lexer.nextToken();
            SQLShowRoleStatement stmt = new SQLShowRoleStatement();
            if (this.lexer.token() == Token.GRANT) {
                this.lexer.nextToken();
                stmt.setGrant(this.exprParser.name());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals("ACL")) {
            this.lexer.nextToken();
            SQLShowACLStatement stmt = new SQLShowACLStatement();
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                stmt.setTable(new SQLExprTableSource(this.exprParser.name()));
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ROLES)) {
            this.lexer.nextToken();
            SQLShowRolesStatement stmt = new SQLShowRolesStatement();
            return stmt;
        }
        if (this.lexer.identifierEquals("HISTORY")) {
            this.lexer.nextToken();
            SQLShowHistoryStatement stmt = new SQLShowHistoryStatement();
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
                    this.lexer.nextToken();
                    stmt.setTables(true);
                } else if (this.lexer.token() == Token.TABLE) {
                    this.lexer.nextToken();
                    stmt.setTable(new SQLExprTableSource(this.exprParser.name()));
                }
            }
            if (this.lexer.token() == Token.LPAREN) {
                this.exprParser.parseAssignItem(stmt.getProperties(), (SQLObject)stmt);
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.exprParser.parseAssignItem(stmt.getPartitions(), (SQLObject)stmt);
            }
            return stmt;
        }
        if (this.lexer.identifierEquals("CHANGELOGS")) {
            this.lexer.nextToken();
            OdpsShowChangelogsStatement stmt = new OdpsShowChangelogsStatement();
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
                    this.lexer.nextToken();
                    stmt.setTables(true);
                } else if (this.lexer.token() == Token.TABLE) {
                    this.lexer.nextToken();
                    stmt.setTable(new SQLExprTableSource(this.exprParser.name()));
                } else if (this.lexer.token() == Token.IDENTIFIER) {
                    stmt.setTable(new SQLExprTableSource(this.exprParser.name()));
                }
            }
            if (this.lexer.token() == Token.LPAREN) {
                this.exprParser.parseAssignItem(stmt.getProperties(), (SQLObject)stmt);
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.exprParser.parseAssignItem(stmt.getPartitions(), (SQLObject)stmt);
            }
            if (this.lexer.token() == Token.LITERAL_INT) {
                stmt.setId(this.exprParser.primary());
            }
            return stmt;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    @Override
    public SQLStatement parseSet() {
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        boolean setProject = false;
        if (this.identifierEquals("SETPROJECT")) {
            this.lexer.nextToken();
            setProject = true;
        } else if (this.dbType == DbType.odps && this.identifierEquals("ALIAS")) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.SET);
        }
        if (this.lexer.token() == Token.SET && this.dbType == DbType.odps) {
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("PROJECT")) {
            this.lexer.nextToken();
            setProject = true;
        }
        if (setProject) {
            SQLSetStatement stmt = new SQLSetStatement();
            stmt.setOption(SQLSetStatement.Option.PROJECT);
            SQLName target = this.exprParser.name();
            this.accept(Token.EQ);
            SQLExpr value = this.exprParser.expr();
            stmt.set(target, value);
            return stmt;
        }
        if (this.lexer.identifierEquals("LABEL")) {
            OdpsSetLabelStatement stmt = new OdpsSetLabelStatement();
            if (comments != null) {
                stmt.addBeforeComment(comments);
            }
            this.lexer.nextToken();
            stmt.setLabel(this.lexer.stringVal());
            this.lexer.nextToken();
            this.accept(Token.TO);
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                SQLName name = this.exprParser.name();
                stmt.setUser(name);
                return stmt;
            }
            this.accept(Token.TABLE);
            SQLName expr = this.exprParser.name();
            stmt.setTable(new SQLExprTableSource(expr));
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(stmt.getColumns(), stmt);
                this.accept(Token.RPAREN);
            }
            return stmt;
        }
        SQLSetStatement stmt = new SQLSetStatement(this.dbType);
        stmt.putAttribute("parser.set", Boolean.TRUE);
        if (comments != null) {
            stmt.addBeforeComment(comments);
        }
        this.parseAssignItems(stmt.getItems(), stmt);
        return stmt;
    }

    @Override
    public OdpsGrantStmt parseGrant() {
        this.accept(Token.GRANT);
        OdpsGrantStmt stmt = new OdpsGrantStmt();
        if (this.lexer.identifierEquals("LABEL")) {
            stmt.setLabel(true);
            this.lexer.nextToken();
            stmt.setLabel(this.exprParser.expr());
        } else {
            if (this.lexer.identifierEquals("SUPER")) {
                stmt.setSuper(true);
                this.lexer.nextToken();
            }
            this.parsePrivileages(stmt.getPrivileges(), stmt);
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("PROJECT")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.PROJECT);
            } else if (this.lexer.identifierEquals("PACKAGE")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.PACKAGE);
            } else if (this.lexer.token() == Token.FUNCTION) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.FUNCTION);
            } else if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.TABLE);
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprParser.names(stmt.getColumns(), stmt);
                    this.accept(Token.RPAREN);
                }
            } else if (this.lexer.identifierEquals("RESOURCE")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.RESOURCE);
            } else if (this.lexer.identifierEquals("INSTANCE")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.INSTANCE);
            } else if (this.lexer.identifierEquals("JOB")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.JOB);
            } else if (this.lexer.identifierEquals("VOLUME")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.VOLUME);
            } else if (this.lexer.identifierEquals("OfflineModel")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.OfflineModel);
            } else if (this.lexer.identifierEquals("XFLOW")) {
                this.lexer.nextToken();
                stmt.setResourceType(SQLObjectType.XFLOW);
            }
            stmt.setResource(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.USER) {
                this.lexer.nextToken();
                stmt.setSubjectType(SQLObjectType.USER);
            } else if (this.lexer.identifierEquals("ROLE")) {
                this.lexer.nextToken();
                stmt.setSubjectType(SQLObjectType.ROLE);
            }
            stmt.getUsers().add(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("EXP");
            stmt.setExpire(this.exprParser.expr());
        }
        return stmt;
    }

    @Override
    protected void parsePrivileages(List<SQLPrivilegeItem> privileges, SQLObject parent) {
        while (true) {
            String privilege = null;
            if (this.lexer.token() == Token.ALL) {
                this.lexer.nextToken();
                privilege = "ALL";
            } else if (this.lexer.token() == Token.SELECT) {
                privilege = "SELECT";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.UPDATE) {
                privilege = "UPDATE";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DELETE) {
                privilege = "DELETE";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.INSERT) {
                privilege = "INSERT";
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                privilege = "DROP";
            } else if (this.lexer.token() == Token.ALTER) {
                this.lexer.nextToken();
                privilege = "ALTER";
            } else if (this.lexer.identifierEquals("DESCRIBE")) {
                privilege = "DESCRIBE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("READ")) {
                privilege = "READ";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("WRITE")) {
                privilege = "WRITE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("EXECUTE")) {
                this.lexer.nextToken();
                privilege = "EXECUTE";
            } else if (this.lexer.identifierEquals("LIST")) {
                this.lexer.nextToken();
                privilege = "LIST";
            } else if (this.lexer.identifierEquals("CreateTable")) {
                this.lexer.nextToken();
                privilege = "CreateTable";
            } else if (this.lexer.identifierEquals("CreateInstance")) {
                this.lexer.nextToken();
                privilege = "CreateInstance";
            } else if (this.lexer.identifierEquals("CreateFunction")) {
                this.lexer.nextToken();
                privilege = "CreateFunction";
            } else if (this.lexer.identifierEquals("CreateResource")) {
                this.lexer.nextToken();
                privilege = "CreateResource";
            } else if (this.lexer.identifierEquals("CreateJob")) {
                this.lexer.nextToken();
                privilege = "CreateJob";
            } else if (this.lexer.identifierEquals("CreateVolume")) {
                this.lexer.nextToken();
                privilege = "CreateVolume";
            } else if (this.lexer.identifierEquals("CreateOfflineModel")) {
                this.lexer.nextToken();
                privilege = "CreateOfflineModel";
            } else if (this.lexer.identifierEquals("CreateXflow")) {
                this.lexer.nextToken();
                privilege = "CreateXflow";
            }
            SQLExpr expr = null;
            expr = privilege != null ? new SQLIdentifierExpr(privilege) : this.exprParser.expr();
            SQLPrivilegeItem privilegeItem = new SQLPrivilegeItem();
            privilegeItem.setAction(expr);
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                while (true) {
                    privilegeItem.getColumns().add(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            expr.setParent(parent);
            privileges.add(privilegeItem);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    @Override
    public SQLCreateFunctionStatement parseCreateFunction() {
        return this.parseHiveCreateFunction();
    }

    protected HiveLoadDataStatement parseLoad() {
        this.acceptIdentifier("LOAD");
        HiveLoadDataStatement stmt = new HiveLoadDataStatement();
        if (this.lexer.token() == Token.OVERWRITE) {
            stmt.setOverwrite(true);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
        }
        this.accept(Token.TABLE);
        stmt.setInto(this.exprParser.expr());
        if (this.lexer.token() == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.exprParser.exprList(stmt.getPartition(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCAL)) {
            this.lexer.nextToken();
            stmt.setLocal(true);
        }
        this.accept(Token.FROM);
        this.acceptIdentifier("LOCATION");
        SQLExpr inpath = this.exprParser.expr();
        stmt.setInpath(inpath);
        if (this.lexer.identifierEquals("STORED")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BY) {
                this.lexer.nextToken();
                stmt.setStoredBy(this.exprParser.expr());
            } else {
                this.accept(Token.AS);
                stmt.setStoredAs(this.exprParser.expr());
            }
        }
        if (this.lexer.identifierEquals("ROW")) {
            this.lexer.nextToken();
            this.acceptIdentifier("FORMAT");
            this.acceptIdentifier("SERDE");
            stmt.setRowFormat(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("SERDEPROPERTIES");
            this.accept(Token.LPAREN);
            while (true) {
                String name = this.lexer.stringVal();
                this.lexer.nextToken();
                this.accept(Token.EQ);
                SQLExpr value = this.exprParser.primary();
                stmt.getSerdeProperties().put(name, value);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals("STORED")) {
            this.lexer.nextToken();
            this.accept(Token.AS);
            stmt.setStoredAs(this.exprParser.expr());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
            stmt.setUsing(this.exprParser.expr());
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCopy() {
        String arguments;
        this.lexer.nextToken();
        int semiPos = this.lexer.text.indexOf(59, this.lexer.pos());
        if (semiPos != -1) {
            int count = semiPos - this.lexer.pos();
            arguments = this.lexer.subString(this.lexer.pos(), count);
            this.lexer.reset(semiPos);
        } else {
            arguments = this.lexer.subString(this.lexer.pos());
            this.lexer.reset(this.lexer.text.length());
        }
        this.lexer.nextToken();
        OdpsCopyStmt stmt = new OdpsCopyStmt();
        stmt.setArguments(arguments);
        return stmt;
    }
}

