/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.security.auth;

import io.pravega.common.Exceptions;
import io.pravega.shared.NameUtils;
import io.pravega.shared.security.auth.AuthorizationResource;
import lombok.NonNull;

public class AuthorizationResourceImpl
implements AuthorizationResource {
    public static final String DOMAIN_PART_SUFFIX = "prn::";
    private static final String TAG_SCOPE = "scope";
    private static final String TAG_STREAM = "stream";
    private static final String TAG_READERGROUP = "reader-group";
    private static final String TAG_KEYVALUETABLE = "key-value-table";
    private static final String ROOT_RESOURCE = String.format("%s/", "prn::");

    @Override
    public String ofScopes() {
        return ROOT_RESOURCE;
    }

    @Override
    public String ofScope(String scopeName) {
        Exceptions.checkNotNullOrEmpty((String)scopeName, (String)"scopeName");
        return String.format("%s/%s:%s", DOMAIN_PART_SUFFIX, TAG_SCOPE, scopeName);
    }

    @Override
    public String ofStreamsInScope(String scopeName) {
        return this.ofScope(scopeName);
    }

    @Override
    public String ofStreamInScope(String scopeName, String streamName) {
        Exceptions.checkNotNullOrEmpty((String)scopeName, (String)"scopeName");
        Exceptions.checkNotNullOrEmpty((String)streamName, (String)"streamName");
        return String.format("%s/%s:%s", this.ofScope(scopeName), TAG_STREAM, streamName);
    }

    @Override
    public String ofReaderGroupsInScope(String scopeName) {
        return this.ofScope(scopeName);
    }

    @Override
    public String ofReaderGroupInScope(String scopeName, String readerGroupName) {
        Exceptions.checkNotNullOrEmpty((String)scopeName, (String)"scopeName");
        Exceptions.checkNotNullOrEmpty((String)readerGroupName, (String)"readerGroupName");
        return String.format("%s/%s:%s", this.ofScope(scopeName), TAG_READERGROUP, readerGroupName);
    }

    @Override
    public String ofKeyValueTablesInScope(String scopeName) {
        return this.ofScope(scopeName);
    }

    @Override
    public String ofKeyValueTableInScope(String scopeName, String keyValueTableName) {
        Exceptions.checkNotNullOrEmpty((String)scopeName, (String)"scopeName");
        Exceptions.checkNotNullOrEmpty((String)keyValueTableName, (String)"keyValueTableName");
        return String.format("%s/%s:%s", this.ofScope(scopeName), TAG_KEYVALUETABLE, keyValueTableName);
    }

    @Override
    public String ofInternalStream(String scopeName, @NonNull String streamName) {
        if (streamName == null) {
            throw new NullPointerException("streamName is marked non-null but is null");
        }
        if (streamName.startsWith("_RG")) {
            return this.ofReaderGroupInScope(scopeName, streamName.replace("_RG", ""));
        }
        if (streamName.startsWith(NameUtils.getMARK_PREFIX())) {
            return this.ofStreamInScope(scopeName, streamName.replace(NameUtils.getMARK_PREFIX(), ""));
        }
        return this.ofStreamInScope(scopeName, streamName);
    }
}

