/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql;

import com.alibaba.otter.canal.filter.CanalEventFilter;
import com.alibaba.otter.canal.filter.aviater.AviaterRegexFilter;
import com.alibaba.otter.canal.parse.CanalEventParser;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.AbstractEventParser;
import com.alibaba.otter.canal.parse.inbound.BinlogParser;
import com.alibaba.otter.canal.parse.inbound.MultiStageCoprocessor;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlMultiStageCoprocessor;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.LogEventConvert;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.DatabaseTableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.DefaultTableMetaTSDBFactory;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.TableMetaTSDB;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.TableMetaTSDBFactory;
import com.alibaba.otter.canal.protocol.position.EntryPosition;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractMysqlEventParser
extends AbstractEventParser {
    protected static final long BINLOG_START_OFFEST = 4L;
    protected TableMetaTSDBFactory tableMetaTSDBFactory = new DefaultTableMetaTSDBFactory();
    protected boolean enableTsdb = false;
    protected String tsdbJdbcUrl;
    protected String tsdbJdbcUserName;
    protected String tsdbJdbcPassword;
    protected int tsdbSnapshotInterval = 24;
    protected int tsdbSnapshotExpire = 360;
    protected String tsdbSpringXml;
    protected TableMetaTSDB tableMetaTSDB;
    protected byte connectionCharsetNumber = (byte)33;
    protected Charset connectionCharset = Charset.forName("UTF-8");
    protected boolean filterQueryDcl = false;
    protected boolean filterQueryDml = false;
    protected boolean filterQueryDdl = false;
    protected boolean filterRows = false;
    protected boolean filterTableError = false;
    protected boolean useDruidDdlFilter = true;
    protected boolean filterDmlInsert = false;
    protected boolean filterDmlUpdate = false;
    protected boolean filterDmlDelete = false;
    protected final AtomicLong receivedBinlogBytes = new AtomicLong(0L);
    private final AtomicLong eventsPublishBlockingTime = new AtomicLong(0L);

    @Override
    protected BinlogParser buildParser() {
        LogEventConvert convert = new LogEventConvert();
        if (this.eventFilter != null && this.eventFilter instanceof AviaterRegexFilter) {
            convert.setNameFilter((AviaterRegexFilter)this.eventFilter);
        }
        if (this.eventBlackFilter != null && this.eventBlackFilter instanceof AviaterRegexFilter) {
            convert.setNameBlackFilter((AviaterRegexFilter)this.eventBlackFilter);
        }
        convert.setFieldFilterMap(this.getFieldFilterMap());
        convert.setFieldBlackFilterMap(this.getFieldBlackFilterMap());
        convert.setCharset(this.connectionCharset);
        convert.setFilterQueryDcl(this.filterQueryDcl);
        convert.setFilterQueryDml(this.filterQueryDml);
        convert.setFilterQueryDdl(this.filterQueryDdl);
        convert.setFilterRows(this.filterRows);
        convert.setFilterTableError(this.filterTableError);
        convert.setUseDruidDdlFilter(this.useDruidDdlFilter);
        return convert;
    }

    @Override
    public void setEventFilter(CanalEventFilter eventFilter) {
        super.setEventFilter(eventFilter);
        if (eventFilter != null && eventFilter instanceof AviaterRegexFilter) {
            if (this.binlogParser instanceof LogEventConvert) {
                ((LogEventConvert)this.binlogParser).setNameFilter((AviaterRegexFilter)eventFilter);
            }
            if (this.tableMetaTSDB != null && this.tableMetaTSDB instanceof DatabaseTableMeta) {
                ((DatabaseTableMeta)this.tableMetaTSDB).setFilter(eventFilter);
            }
        }
    }

    @Override
    public void setEventBlackFilter(CanalEventFilter eventBlackFilter) {
        super.setEventBlackFilter(eventBlackFilter);
        if (eventBlackFilter != null && eventBlackFilter instanceof AviaterRegexFilter) {
            if (this.binlogParser instanceof LogEventConvert) {
                ((LogEventConvert)this.binlogParser).setNameBlackFilter((AviaterRegexFilter)eventBlackFilter);
            }
            if (this.tableMetaTSDB != null && this.tableMetaTSDB instanceof DatabaseTableMeta) {
                ((DatabaseTableMeta)this.tableMetaTSDB).setBlackFilter(eventBlackFilter);
            }
        }
    }

    @Override
    public void setFieldFilter(String fieldFilter) {
        super.setFieldFilter(fieldFilter);
        if (this.binlogParser instanceof LogEventConvert) {
            ((LogEventConvert)this.binlogParser).setFieldFilterMap(this.getFieldFilterMap());
        }
        if (this.tableMetaTSDB != null && this.tableMetaTSDB instanceof DatabaseTableMeta) {
            ((DatabaseTableMeta)this.tableMetaTSDB).setFieldFilterMap(this.getFieldFilterMap());
        }
    }

    @Override
    public void setFieldBlackFilter(String fieldBlackFilter) {
        super.setFieldBlackFilter(fieldBlackFilter);
        if (this.binlogParser instanceof LogEventConvert) {
            ((LogEventConvert)this.binlogParser).setFieldBlackFilterMap(this.getFieldBlackFilterMap());
        }
        if (this.tableMetaTSDB != null && this.tableMetaTSDB instanceof DatabaseTableMeta) {
            ((DatabaseTableMeta)this.tableMetaTSDB).setFieldBlackFilterMap(this.getFieldBlackFilterMap());
        }
    }

    @Override
    protected boolean processTableMeta(EntryPosition position) {
        if (this.tableMetaTSDB != null) {
            if (position.getTimestamp() == null || position.getTimestamp() <= 0L) {
                throw new CanalParseException("use gtid and TableMeta TSDB should be config timestamp > 0");
            }
            return this.tableMetaTSDB.rollback(position);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void start() throws CanalParseException {
        if (this.enableTsdb && this.tableMetaTSDB == null) {
            Class<CanalEventParser> clazz = CanalEventParser.class;
            // MONITORENTER : com.alibaba.otter.canal.parse.CanalEventParser.class
            this.buildTableMetaTSDB(this.tsdbSpringXml);
            // MONITOREXIT : clazz
        }
        super.start();
    }

    @Override
    public void stop() throws CanalParseException {
        if (this.enableTsdb) {
            this.tableMetaTSDBFactory.destory(this.destination);
            this.tableMetaTSDB = null;
        }
        super.stop();
    }

    protected synchronized void buildTableMetaTSDB(String tsdbSpringXml) {
        if (this.tableMetaTSDB != null) {
            return;
        }
        try {
            System.setProperty("canal.instance.tsdb.url", this.tsdbJdbcUrl);
            System.setProperty("canal.instance.tsdb.dbUsername", this.tsdbJdbcUserName);
            System.setProperty("canal.instance.tsdb.dbPassword", this.tsdbJdbcPassword);
            this.tableMetaTSDB = this.tableMetaTSDBFactory.build(this.destination, tsdbSpringXml);
        }
        catch (Throwable e) {
            this.logger.warn("failed to build TableMetaTSDB ", e);
            throw new CanalParseException(e);
        }
        finally {
            System.setProperty("canal.instance.tsdb.url", "");
            System.setProperty("canal.instance.tsdb.dbUsername", "");
            System.setProperty("canal.instance.tsdb.dbPassword", "");
        }
    }

    @Override
    protected MultiStageCoprocessor buildMultiStageCoprocessor() {
        MysqlMultiStageCoprocessor mysqlMultiStageCoprocessor = new MysqlMultiStageCoprocessor(this.parallelBufferSize, this.parallelThreadSize, (LogEventConvert)this.binlogParser, this.transactionBuffer, this.destination, this.filterDmlInsert, this.filterDmlUpdate, this.filterDmlDelete);
        mysqlMultiStageCoprocessor.setEventsPublishBlockingTime(this.eventsPublishBlockingTime);
        return mysqlMultiStageCoprocessor;
    }

    public void setConnectionCharsetNumber(byte connectionCharsetNumber) {
        this.connectionCharsetNumber = connectionCharsetNumber;
    }

    public void setConnectionCharsetStd(Charset connectionCharset) {
        this.connectionCharset = connectionCharset;
    }

    public void setConnectionCharset(String connectionCharset) {
        if ("UTF8MB4".equalsIgnoreCase(connectionCharset)) {
            connectionCharset = "UTF-8";
        }
        this.connectionCharset = Charset.forName(connectionCharset);
    }

    public void setFilterQueryDcl(boolean filterQueryDcl) {
        this.filterQueryDcl = filterQueryDcl;
    }

    public void setFilterQueryDml(boolean filterQueryDml) {
        this.filterQueryDml = filterQueryDml;
    }

    public void setFilterQueryDdl(boolean filterQueryDdl) {
        this.filterQueryDdl = filterQueryDdl;
    }

    public void setFilterRows(boolean filterRows) {
        this.filterRows = filterRows;
    }

    public void setFilterTableError(boolean filterTableError) {
        this.filterTableError = filterTableError;
    }

    public boolean isUseDruidDdlFilter() {
        return this.useDruidDdlFilter;
    }

    public void setUseDruidDdlFilter(boolean useDruidDdlFilter) {
        this.useDruidDdlFilter = useDruidDdlFilter;
    }

    public boolean isFilterDmlInsert() {
        return this.filterDmlInsert;
    }

    public void setFilterDmlInsert(boolean filterDmlInsert) {
        this.filterDmlInsert = filterDmlInsert;
    }

    public boolean isFilterDmlUpdate() {
        return this.filterDmlUpdate;
    }

    public void setFilterDmlUpdate(boolean filterDmlUpdate) {
        this.filterDmlUpdate = filterDmlUpdate;
    }

    public boolean isFilterDmlDelete() {
        return this.filterDmlDelete;
    }

    public void setFilterDmlDelete(boolean filterDmlDelete) {
        this.filterDmlDelete = filterDmlDelete;
    }

    public void setEnableTsdb(boolean enableTsdb) {
        this.enableTsdb = enableTsdb;
    }

    public void setTsdbSpringXml(String tsdbSpringXml) {
        this.tsdbSpringXml = tsdbSpringXml;
    }

    public void setTableMetaTSDBFactory(TableMetaTSDBFactory tableMetaTSDBFactory) {
        this.tableMetaTSDBFactory = tableMetaTSDBFactory;
    }

    public AtomicLong getEventsPublishBlockingTime() {
        return this.eventsPublishBlockingTime;
    }

    public AtomicLong getReceivedBinlogBytes() {
        return this.receivedBinlogBytes;
    }

    public int getTsdbSnapshotInterval() {
        return this.tsdbSnapshotInterval;
    }

    public void setTsdbSnapshotInterval(int tsdbSnapshotInterval) {
        this.tsdbSnapshotInterval = tsdbSnapshotInterval;
    }

    public int getTsdbSnapshotExpire() {
        return this.tsdbSnapshotExpire;
    }

    public void setTsdbSnapshotExpire(int tsdbSnapshotExpire) {
        this.tsdbSnapshotExpire = tsdbSnapshotExpire;
    }

    public void setTsdbJdbcUrl(String tsdbJdbcUrl) {
        this.tsdbJdbcUrl = tsdbJdbcUrl;
    }

    public void setTsdbJdbcUserName(String tsdbJdbcUserName) {
        this.tsdbJdbcUserName = tsdbJdbcUserName;
    }

    public void setTsdbJdbcPassword(String tsdbJdbcPassword) {
        this.tsdbJdbcPassword = tsdbJdbcPassword;
    }
}

