/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.raft;

import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.RaftServiceFactory;
import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.CliServiceImpl;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RemotingException;
import com.alipay.sofa.jraft.option.CliOptions;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.rpc.CliClientService;
import com.alipay.sofa.jraft.rpc.impl.cli.CliClientServiceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.api.exception.MetaException;
import org.apache.eventmesh.api.meta.MetaService;
import org.apache.eventmesh.api.meta.MetaServiceListener;
import org.apache.eventmesh.api.meta.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.meta.raft.EventClosure;
import org.apache.eventmesh.meta.raft.JraftServer;
import org.apache.eventmesh.meta.raft.config.RaftMetaStorageConfiguration;
import org.apache.eventmesh.meta.raft.rpc.MetaServerHelper;
import org.apache.eventmesh.meta.raft.rpc.RequestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftMetaService
implements MetaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RaftMetaService.class);
    private static ObjectMapper objectMapper = new ObjectMapper();
    private ConcurrentMap<String, EventMeshRegisterInfo> eventMeshRegisterInfoMap;
    private final AtomicBoolean initStatus = new AtomicBoolean(false);
    private final AtomicBoolean startStatus = new AtomicBoolean(false);
    RaftMetaStorageConfiguration configuration;
    private JraftServer jraftServer;
    private CliService cliService;
    private CliClientServiceImpl cliClientService;
    private PeerId leader;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    public void init() throws MetaException {
        if (!this.initStatus.compareAndSet(false, true)) {
            return;
        }
        this.eventMeshRegisterInfoMap = new ConcurrentHashMap<String, EventMeshRegisterInfo>(ConfigurationContextUtil.KEYS.size());
        ConfigService configService = ConfigService.getInstance();
        this.configuration = (RaftMetaStorageConfiguration)configService.buildConfigInstance(RaftMetaStorageConfiguration.class);
    }

    public void start() throws MetaException {
        String dataPath = this.configuration.getDataPath();
        String groupId = "EM_META";
        String serverIdStr = this.configuration.getSelfIpAndPort();
        String initConfStr = this.configuration.getMembersIpAndPort();
        NodeOptions nodeOptions = new NodeOptions();
        nodeOptions.setElectionTimeoutMs(this.configuration.getElectionTimeoutMs() * 1000);
        nodeOptions.setDisableCli(false);
        nodeOptions.setSnapshotIntervalSecs(this.configuration.getSnapshotIntervalSecs().intValue());
        PeerId serverId = new PeerId();
        if (!serverId.parse(serverIdStr)) {
            throw new MetaException("Fail to parse serverId:" + serverIdStr);
        }
        Configuration initConf = new Configuration();
        if (!initConf.parse(initConfStr)) {
            throw new MetaException("Fail to parse initConf:" + initConfStr);
        }
        initConf.addPeer(serverId);
        nodeOptions.setInitialConf(initConf);
        try {
            this.jraftServer = new JraftServer(dataPath, "EM_META", serverId, nodeOptions);
        }
        catch (IOException e) {
            throw new MetaException("fail to start jraft server", (Throwable)e);
        }
        log.info("Started jraft server at port: {}", (Object)this.jraftServer.getNode().getNodeId().getPeerId().getPort());
        Configuration conf = new Configuration();
        if (!conf.parse(serverIdStr)) {
            throw new IllegalArgumentException("Fail to parse conf:" + serverIdStr);
        }
        RouteTable.getInstance().updateConfiguration("EM_META", conf);
        this.cliService = RaftServiceFactory.createAndInitCliService((CliOptions)new CliOptions());
        this.cliClientService = (CliClientServiceImpl)((CliServiceImpl)this.cliService).getCliClientService();
        while (true) {
            try {
                do {
                    this.refreshleader();
                } while (this.leader == null);
            }
            catch (Exception e) {
                log.warn("fail to get leader node");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.refreshleader();
            }
            catch (Exception e) {
                log.error("fail to Refresh Leader", (Throwable)e);
            }
        }, this.configuration.getRefreshLeaderInterval().intValue(), this.configuration.getRefreshLeaderInterval().intValue(), TimeUnit.SECONDS);
        this.startStatus.compareAndSet(false, true);
    }

    private void refreshleader() throws InterruptedException, TimeoutException {
        if (!RouteTable.getInstance().refreshLeader((CliClientService)this.cliClientService, "EM_META", 3000).isOk()) {
            throw new IllegalStateException("Refresh leader failed");
        }
        this.leader = RouteTable.getInstance().selectLeader("EM_META");
        log.info("raft Leader is {}", (Object)this.leader);
    }

    public void shutdown() throws MetaException {
        if (!this.startStatus.compareAndSet(true, false)) {
            return;
        }
        this.scheduledExecutorService.shutdown();
        MetaServerHelper.shutDown();
        if (this.cliService != null) {
            this.cliService.shutdown();
        }
        if (this.cliClientService != null) {
            this.cliClientService.shutdown();
        }
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws MetaException {
        ArrayList<EventMeshDataInfo> listEventMeshDataInfo = new ArrayList<EventMeshDataInfo>();
        RequestResponse req = RequestResponse.newBuilder().setValue(2L).build();
        boolean result = false;
        try {
            CompletableFuture<RequestResponse> future = this.commit(req, EventClosure.createDefaultEventClosure());
            RequestResponse requestResponse = future.get(3000L, TimeUnit.MILLISECONDS);
            if (requestResponse != null && (result = requestResponse.getSuccess())) {
                Map<String, String> infoMap = requestResponse.getInfoMap();
                for (Map.Entry<String, String> entry : infoMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (!key.startsWith("eventMeshInfo@@") || Objects.isNull(clusterName) && !key.endsWith("@@" + clusterName)) continue;
                    EventMeshDataInfo eventMeshDataInfo = (EventMeshDataInfo)objectMapper.readValue(value, EventMeshDataInfo.class);
                    listEventMeshDataInfo.add(eventMeshDataInfo);
                }
            }
        }
        catch (Exception e) {
            throw new MetaException("fail to get meta data ", (Throwable)e);
        }
        return listEventMeshDataInfo;
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws MetaException {
        return this.findEventMeshInfoByCluster(null);
    }

    public void registerMetadata(Map<String, String> metadataMap) {
        for (Map.Entry eventMeshRegisterInfo : this.eventMeshRegisterInfoMap.entrySet()) {
            EventMeshRegisterInfo registerInfo = (EventMeshRegisterInfo)eventMeshRegisterInfo.getValue();
            registerInfo.setMetadata(metadataMap);
            this.register(registerInfo);
        }
    }

    public Map<String, String> getMetaData(String key, boolean fuzzyEnabled) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        RequestResponse req = RequestResponse.newBuilder().setValue(2L).build();
        boolean result = false;
        try {
            CompletableFuture<RequestResponse> future = this.commit(req, EventClosure.createDefaultEventClosure());
            RequestResponse requestResponse = future.get(3000L, TimeUnit.MILLISECONDS);
            if (requestResponse != null && (result = requestResponse.getSuccess())) {
                Map<String, String> infoMap = requestResponse.getInfoMap();
                resultMap.putAll(infoMap);
            }
        }
        catch (Exception e) {
            throw new MetaException("fail to get meta data ", (Throwable)e);
        }
        if (!fuzzyEnabled) {
            HashMap<String, String> finalResult = new HashMap<String, String>();
            finalResult.put(key, (String)resultMap.get(key));
            return finalResult;
        }
        return resultMap;
    }

    public void getMetaDataWithListener(MetaServiceListener metaServiceListener, String key) {
    }

    public void updateMetaData(Map<String, String> metadataMap) {
        String protocol = metadataMap.get("protocol");
        String reftDataId = "Raft@@" + protocol;
        boolean result = false;
        try {
            RequestResponse req = RequestResponse.newBuilder().setValue(1L).putInfo(reftDataId, objectMapper.writeValueAsString(metadataMap)).build();
            CompletableFuture<RequestResponse> future = this.commit(req, EventClosure.createDefaultEventClosure());
            RequestResponse requestResponse = future.get(3000L, TimeUnit.MILLISECONDS);
            if (requestResponse != null) {
                result = requestResponse.getSuccess();
            }
        }
        catch (Exception e) {
            throw new MetaException("fail to serialize ", (Throwable)e);
        }
        if (!result) {
            throw new MetaException("fail to updateMetaData ");
        }
    }

    public void removeMetaData(String key) {
        RequestResponse req = RequestResponse.newBuilder().setValue(3L).putInfo(key, "").build();
        try {
            boolean result;
            CompletableFuture<RequestResponse> future = this.commit(req, EventClosure.createDefaultEventClosure());
            RequestResponse requestResponse = future.get(3000L, TimeUnit.MILLISECONDS);
            if (requestResponse != null && (result = requestResponse.getSuccess())) {
                throw new MetaException("fail to remove MetaData");
            }
        }
        catch (Exception e) {
            throw new MetaException("fail to remove MetaData", (Throwable)e);
        }
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws MetaException {
        String eventMeshName = eventMeshRegisterInfo.getEventMeshName();
        String protocolType = eventMeshRegisterInfo.getProtocolType();
        String[] ipAndPort = eventMeshRegisterInfo.getEndPoint().split(":");
        String clusterName = eventMeshRegisterInfo.getEventMeshClusterName();
        String key = "eventMeshInfo@@" + eventMeshName + "@@" + ipAndPort[0] + "@@" + ipAndPort[1] + "@@" + protocolType + "@@" + clusterName;
        InfoInner infoInner = new InfoInner(eventMeshRegisterInfo);
        String registerInfo = null;
        boolean result = false;
        try {
            registerInfo = objectMapper.writeValueAsString((Object)infoInner);
            RequestResponse req = RequestResponse.newBuilder().setValue(1L).putInfo(key, registerInfo).build();
            CompletableFuture<RequestResponse> future = this.commit(req, EventClosure.createDefaultEventClosure());
            RequestResponse requestResponse = future.get(3000L, TimeUnit.MILLISECONDS);
            if (requestResponse != null) {
                result = requestResponse.getSuccess();
            }
        }
        catch (Exception e) {
            throw new MetaException("fail to serialize ", (Throwable)e);
        }
        if (result) {
            this.eventMeshRegisterInfoMap.put(eventMeshName, eventMeshRegisterInfo);
        }
        return result;
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws MetaException {
        String eventMeshName = eventMeshUnRegisterInfo.getEventMeshName();
        String protocolType = eventMeshUnRegisterInfo.getProtocolType();
        String[] ipAndPort = eventMeshUnRegisterInfo.getEndPoint().split(":");
        String clusterName = eventMeshUnRegisterInfo.getEventMeshClusterName();
        String key = "eventMeshInfo@@" + eventMeshName + "@@" + ipAndPort[0] + "@@" + ipAndPort[1] + "@@" + protocolType + "@@" + clusterName;
        RequestResponse req = RequestResponse.newBuilder().setValue(3L).putInfo(key, "").build();
        boolean result = false;
        try {
            CompletableFuture<RequestResponse> future = this.commit(req, EventClosure.createDefaultEventClosure());
            RequestResponse requestResponse = future.get(3000L, TimeUnit.MILLISECONDS);
            if (requestResponse != null) {
                result = requestResponse.getSuccess();
            }
        }
        catch (Exception e) {
            throw new MetaException(e.getMessage(), (Throwable)e);
        }
        if (result) {
            this.eventMeshRegisterInfoMap.remove(eventMeshName);
        }
        return result;
    }

    public CompletableFuture<RequestResponse> commit(RequestResponse requestResponse, EventClosure eventClosure) throws RemotingException, InterruptedException {
        CompletableFuture<RequestResponse> future = new CompletableFuture<RequestResponse>();
        eventClosure.setFuture(future);
        if (this.isLeader()) {
            this.jraftServer.getMetaImpl().handle(requestResponse, eventClosure);
        } else {
            this.invokeToLeader(requestResponse, future);
        }
        return future;
    }

    private void invokeToLeader(RequestResponse requestResponse, CompletableFuture<RequestResponse> future) throws RemotingException, InterruptedException {
        this.cliClientService.getRpcClient().invokeAsync(this.leader.getEndpoint(), (Object)requestResponse, (result, err) -> {
            if (err != null) {
                future.completeExceptionally(err);
                return;
            }
            future.complete((RequestResponse)result);
        }, 3000L);
    }

    private boolean isLeader() {
        return this.jraftServer.getFsm().isLeader();
    }

    class InfoInner
    implements Serializable {
        EventMeshRegisterInfo eventMeshRegisterInfo;

        public InfoInner(EventMeshRegisterInfo eventMeshRegisterInfo) {
            this.eventMeshRegisterInfo = eventMeshRegisterInfo;
        }

        @Generated
        public EventMeshRegisterInfo getEventMeshRegisterInfo() {
            return this.eventMeshRegisterInfo;
        }

        @Generated
        public void setEventMeshRegisterInfo(EventMeshRegisterInfo eventMeshRegisterInfo) {
            this.eventMeshRegisterInfo = eventMeshRegisterInfo;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InfoInner)) {
                return false;
            }
            InfoInner other = (InfoInner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EventMeshRegisterInfo this$eventMeshRegisterInfo = this.getEventMeshRegisterInfo();
            EventMeshRegisterInfo other$eventMeshRegisterInfo = other.getEventMeshRegisterInfo();
            return !(this$eventMeshRegisterInfo == null ? other$eventMeshRegisterInfo != null : !this$eventMeshRegisterInfo.equals(other$eventMeshRegisterInfo));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InfoInner;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EventMeshRegisterInfo $eventMeshRegisterInfo = this.getEventMeshRegisterInfo();
            result = result * 59 + ($eventMeshRegisterInfo == null ? 43 : $eventMeshRegisterInfo.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RaftMetaService.InfoInner(eventMeshRegisterInfo=" + this.getEventMeshRegisterInfo() + ")";
        }
    }
}

