/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.common.ComponentLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponent
implements ComponentLifeCycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractComponent.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    @Override
    public void start() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            log.info("component [{}] has started", this.getClass());
            return;
        }
        log.info("component [{}] will start", this.getClass());
        this.run();
        log.info("component [{}] started successfully", this.getClass());
    }

    @Override
    public void stop() throws Exception {
        if (!this.stopped.compareAndSet(false, true)) {
            log.info("component [{}] has stopped", this.getClass());
            return;
        }
        log.info("component [{}] will stop", this.getClass());
        this.shutdown();
        log.info("component [{}] stopped successfully", this.getClass());
    }

    protected abstract void run() throws Exception;

    protected abstract void shutdown() throws Exception;
}

