/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.store;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.meta.CanalMetaManager;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import com.alibaba.otter.canal.protocol.position.Position;
import com.alibaba.otter.canal.store.CanalStoreScavenge;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;

public abstract class AbstractCanalStoreScavenge
extends AbstractCanalLifeCycle
implements CanalStoreScavenge {
    protected String destination;
    protected CanalMetaManager canalMetaManager;
    protected boolean onAck = true;
    protected boolean onFull = false;
    protected boolean onSchedule = false;
    protected String scavengeSchedule = null;

    public void scavenge() {
        Position position = this.getLatestAckPosition(this.destination);
        this.cleanUntil(position);
    }

    private Position getLatestAckPosition(String destination) {
        List clientIdentitys = this.canalMetaManager.listAllSubscribeInfo(destination);
        LogPosition result = null;
        if (!CollectionUtils.isEmpty((Collection)clientIdentitys)) {
            for (ClientIdentity clientIdentity : clientIdentitys) {
                LogPosition position = (LogPosition)this.canalMetaManager.getCursor(clientIdentity);
                if (position == null) continue;
                if (result == null) {
                    result = position;
                    continue;
                }
                result = this.min(result, position);
            }
        }
        return result;
    }

    private LogPosition min(LogPosition position1, LogPosition position2) {
        if (position1.getIdentity().equals((Object)position2.getIdentity())) {
            if (position1.getPostion().getJournalName().compareTo(position2.getPostion().getJournalName()) < 0) {
                return position2;
            }
            if (position1.getPostion().getJournalName().compareTo(position2.getPostion().getJournalName()) > 0) {
                return position1;
            }
            if (position1.getPostion().getPosition() < position2.getPostion().getPosition()) {
                return position2;
            }
            return position1;
        }
        if (position1.getPostion().getTimestamp() < position2.getPostion().getTimestamp()) {
            return position2;
        }
        return position1;
    }

    public void setOnAck(boolean onAck) {
        this.onAck = onAck;
    }

    public void setOnFull(boolean onFull) {
        this.onFull = onFull;
    }

    public void setOnSchedule(boolean onSchedule) {
        this.onSchedule = onSchedule;
    }

    public String getScavengeSchedule() {
        return this.scavengeSchedule;
    }

    public void setScavengeSchedule(String scavengeSchedule) {
        this.scavengeSchedule = scavengeSchedule;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setCanalMetaManager(CanalMetaManager canalMetaManager) {
        this.canalMetaManager = canalMetaManager;
    }
}

