/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.AnnotationKeyMatcher;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.trace.ServiceTypeInfo;
import com.navercorp.pinpoint.common.trace.TraceMetadataProvider;
import com.navercorp.pinpoint.common.trace.TraceMetadataSetupContext;
import java.util.List;

public class ParsedTraceMetadataProvider
implements TraceMetadataProvider {
    private final String id;
    private final List<ServiceTypeInfo> serviceTypeInfos;
    private final List<AnnotationKey> annotationKeys;

    public ParsedTraceMetadataProvider(String id, List<ServiceTypeInfo> serviceTypeInfos, List<AnnotationKey> annotationKeys) {
        this.id = id;
        this.serviceTypeInfos = serviceTypeInfos;
        this.annotationKeys = annotationKeys;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void setup(TraceMetadataSetupContext context) {
        for (ServiceTypeInfo serviceTypeInfo : this.serviceTypeInfos) {
            ServiceType serviceType = serviceTypeInfo.getServiceType();
            AnnotationKeyMatcher annotationKeyMatcher = serviceTypeInfo.getPrimaryAnnotationKeyMatcher();
            if (annotationKeyMatcher != null) {
                context.addServiceType(serviceType, annotationKeyMatcher);
                continue;
            }
            context.addServiceType(serviceType);
        }
        for (AnnotationKey annotationKey : this.annotationKeys) {
            context.addAnnotationKey(annotationKey);
        }
    }

    public String toString() {
        return this.id;
    }
}

