/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Objects;

public final class CodeSourceUtils {
    private CodeSourceUtils() {
    }

    public static URL getCodeLocation(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        return CodeSourceUtils.getCodeLocation(protectionDomain);
    }

    public static URL getCodeLocation(ProtectionDomain protectionDomain) {
        if (protectionDomain == null) {
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return null;
        }
        return codeSource.getLocation();
    }
}

