/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.auth.v3;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.auth.v3.model.CreateAppAccessTokenReq;
import com.lark.oapi.service.auth.v3.model.CreateAppAccessTokenResp;
import com.lark.oapi.service.auth.v3.model.CreateTenantAccessTokenReq;
import com.lark.oapi.service.auth.v3.model.CreateTenantAccessTokenResp;
import com.lark.oapi.service.auth.v3.model.InternalAppAccessTokenReq;
import com.lark.oapi.service.auth.v3.model.InternalAppAccessTokenResp;
import com.lark.oapi.service.auth.v3.model.InternalTenantAccessTokenReq;
import com.lark.oapi.service.auth.v3.model.InternalTenantAccessTokenResp;
import com.lark.oapi.service.auth.v3.model.ResendAppTicketReq;
import com.lark.oapi.service.auth.v3.model.ResendAppTicketResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthService.class);
    private final AppAccessToken appAccessToken;
    private final AppTicket appTicket;
    private final TenantAccessToken tenantAccessToken;

    public AuthService(Config config) {
        this.appAccessToken = new AppAccessToken(config);
        this.appTicket = new AppTicket(config);
        this.tenantAccessToken = new TenantAccessToken(config);
    }

    public AppAccessToken appAccessToken() {
        return this.appAccessToken;
    }

    public AppTicket appTicket() {
        return this.appTicket;
    }

    public TenantAccessToken tenantAccessToken() {
        return this.tenantAccessToken;
    }

    public static class TenantAccessToken {
        private final Config config;

        public TenantAccessToken(Config config) {
            this.config = config;
        }

        public CreateTenantAccessTokenResp create(CreateTenantAccessTokenReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateTenantAccessTokenResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/auth/v3/tenant_access_token", Sets.newHashSet(), req), CreateTenantAccessTokenResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/auth/v3/tenant_access_token", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateTenantAccessTokenResp create(CreateTenantAccessTokenReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/auth/v3/tenant_access_token", Sets.newHashSet(), req);
            CreateTenantAccessTokenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateTenantAccessTokenResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/auth/v3/tenant_access_token", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public InternalTenantAccessTokenResp internal(InternalTenantAccessTokenReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            InternalTenantAccessTokenResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/auth/v3/tenant_access_token/internal", Sets.newHashSet(), req), InternalTenantAccessTokenResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/auth/v3/tenant_access_token/internal", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public InternalTenantAccessTokenResp internal(InternalTenantAccessTokenReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/auth/v3/tenant_access_token/internal", Sets.newHashSet(), req);
            InternalTenantAccessTokenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, InternalTenantAccessTokenResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/auth/v3/tenant_access_token/internal", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class AppTicket {
        private final Config config;

        public AppTicket(Config config) {
            this.config = config;
        }

        public ResendAppTicketResp resend(ResendAppTicketReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ResendAppTicketResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/auth/v3/app_ticket/resend", Sets.newHashSet(), req), ResendAppTicketResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/auth/v3/app_ticket/resend", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ResendAppTicketResp resend(ResendAppTicketReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/auth/v3/app_ticket/resend", Sets.newHashSet(), req);
            ResendAppTicketResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ResendAppTicketResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/auth/v3/app_ticket/resend", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class AppAccessToken {
        private final Config config;

        public AppAccessToken(Config config) {
            this.config = config;
        }

        public CreateAppAccessTokenResp create(CreateAppAccessTokenReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateAppAccessTokenResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/auth/v3/app_access_token", Sets.newHashSet(), req), CreateAppAccessTokenResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/auth/v3/app_access_token", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateAppAccessTokenResp create(CreateAppAccessTokenReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/auth/v3/app_access_token", Sets.newHashSet(), req);
            CreateAppAccessTokenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateAppAccessTokenResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/auth/v3/app_access_token", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public InternalAppAccessTokenResp internal(InternalAppAccessTokenReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            InternalAppAccessTokenResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/auth/v3/app_access_token/internal", Sets.newHashSet(), req), InternalAppAccessTokenResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/auth/v3/app_access_token/internal", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public InternalAppAccessTokenResp internal(InternalAppAccessTokenReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/auth/v3/app_access_token/internal", Sets.newHashSet(), req);
            InternalAppAccessTokenResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, InternalAppAccessTokenResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/auth/v3/app_access_token/internal", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

