/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.buffer;

import com.navercorp.pinpoint.common.buffer.AutomaticBuffer;
import java.nio.ByteBuffer;

public class OffsetAutomaticBuffer
extends AutomaticBuffer {
    protected int startOffset;
    protected int endOffset;

    public OffsetAutomaticBuffer(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public OffsetAutomaticBuffer(byte[] buffer, int startOffset, int length) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (startOffset < 0) {
            throw new IndexOutOfBoundsException("negative offset:" + startOffset);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("negative length:" + length);
        }
        if (startOffset > buffer.length) {
            throw new IndexOutOfBoundsException("startOffset:" + startOffset + " > buffer.length:" + buffer.length);
        }
        int endOffset = startOffset + length;
        if (endOffset > buffer.length) {
            throw new IndexOutOfBoundsException("too large length buffer.length:" + buffer.length + " endOffset:" + endOffset);
        }
        this.buffer = buffer;
        this.offset = startOffset;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    protected void checkExpand(int size) {
        super.checkExpand(size);
        this.endOffset = this.buffer.length;
    }

    @Override
    public byte[] getBuffer() {
        if (this.startOffset == 0 && this.offset == this.buffer.length) {
            return this.buffer;
        }
        return this.copyBuffer();
    }

    @Override
    public byte[] copyBuffer() {
        int length = this.offset - this.startOffset;
        byte[] copy = new byte[length];
        System.arraycopy(this.buffer, this.startOffset, copy, 0, length);
        return copy;
    }

    @Override
    public ByteBuffer wrapByteBuffer() {
        int length = this.offset - this.startOffset;
        return ByteBuffer.wrap(this.buffer, this.startOffset, length);
    }

    @Override
    public int remaining() {
        return this.endOffset - this.offset;
    }

    @Override
    public boolean hasRemaining() {
        return this.offset < this.endOffset;
    }
}

