/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.presto.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableLike;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoCreateTableStatement;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class PrestoCreateTableParser
extends SQLCreateTableParser {
    public PrestoCreateTableParser(String sql) {
        super(sql);
    }

    public PrestoCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        SQLCreateTableStatement stmt = this.parseCreateTable(true);
        if (comments != null) {
            stmt.addBeforeComment(comments);
        }
        return stmt;
    }

    @Override
    public SQLCreateTableStatement parseCreateTable(boolean acceptCreate) {
        PrestoCreateTableStatement createTable = this.newCreateStatement();
        createTable.setDbType(this.getDbType());
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                createTable.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals(FnvHash.Constants.IF)) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createTable.setIfNotExiists(true);
        }
        createTable.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            do {
                SQLColumnDefinition column;
                Token token = this.lexer.token();
                if (this.lexer.token() == Token.LIKE) {
                    this.lexer.nextToken();
                    SQLTableLike tableLike = new SQLTableLike();
                    tableLike.setTable(new SQLExprTableSource(this.exprParser.name()));
                    tableLike.setParent(createTable);
                    createTable.getTableElementList().add(tableLike);
                    if (this.lexer.identifierEquals(FnvHash.Constants.INCLUDING)) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("PROPERTIES");
                        tableLike.setIncludeProperties(true);
                    } else if (this.lexer.identifierEquals(FnvHash.Constants.EXCLUDING)) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("PROPERTIES");
                        tableLike.setExcludeProperties(true);
                    }
                } else if (token == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
                    column = this.exprParser.parseColumn(createTable);
                    column.setParent(createTable);
                    createTable.getTableElementList().add(column);
                } else {
                    column = this.exprParser.parseColumn();
                    createTable.getTableElementList().add(column);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            SQLExpr comment = this.exprParser.expr();
            createTable.setComment(comment);
        }
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(createTable.getTableOptions(), createTable, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            SQLSelect select = this.createSQLSelectParser().select();
            createTable.setSelect(select);
        }
        this.parseCreateTableRest(createTable);
        return createTable;
    }

    @Override
    protected PrestoCreateTableStatement newCreateStatement() {
        return new PrestoCreateTableStatement();
    }
}

