/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import java.beans.ConstructorProperties;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AsyncSemaphore
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncSemaphore.class);
    private final long totalCredits;
    private final String logId;
    @GuardedBy(value="queue")
    private long usedCredits;
    @GuardedBy(value="queue")
    private final ArrayDeque<PendingTask<?>> queue;
    @GuardedBy(value="queue")
    private boolean closed;

    public AsyncSemaphore(long totalCredits, long usedCredits, String logId) {
        Preconditions.checkArgument((totalCredits > 0L ? 1 : 0) != 0, (Object)"totalCredits must be a positive integer");
        Preconditions.checkArgument((usedCredits >= 0L ? 1 : 0) != 0, (Object)"usedCredits must be a non-negative integer");
        this.totalCredits = totalCredits;
        this.usedCredits = usedCredits;
        this.logId = logId;
        this.queue = new ArrayDeque();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList toCancel = null;
        ArrayDeque<PendingTask<?>> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            if (!this.closed) {
                toCancel = new ArrayList(this.queue);
                this.queue.clear();
                this.usedCredits = 0L;
                this.closed = true;
            }
        }
        if (toCancel != null && !toCancel.isEmpty()) {
            log.debug("AsyncSemaphore[{}]: Closing. Cancelling {} task(s).", (Object)this.logId, (Object)toCancel.size());
            toCancel.forEach(task -> task.result.cancel(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> CompletableFuture<T> run(@NonNull Supplier<CompletableFuture<T>> task, long credits, boolean force) {
        PendingTask<T> pt;
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        Preconditions.checkArgument((credits >= 0L && credits <= this.totalCredits ? 1 : 0) != 0, (String)"credits must be a non-negative number smaller than or equal to %s.", (long)this.totalCredits);
        ArrayDeque<PendingTask<?>> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            Exceptions.checkNotClosed(this.closed, this);
            if (force || this.canExecute(credits)) {
                pt = null;
                this.usedCredits += credits;
                log.trace("AsyncSemaphore[{}]: Task run. Credits={}, TotalUsedCredits={}, Forced={}.", new Object[]{this.logId, credits, this.usedCredits, force});
            } else {
                pt = new PendingTask<T>(credits, task);
                this.queue.addLast(pt);
                log.debug("AsyncSemaphore[{}]: Task blocked. Credits={}, TotalUsedCredits={}, QueueSize={}.", new Object[]{this.logId, credits, this.usedCredits, this.queue.size()});
            }
        }
        if (pt == null) {
            return this.execute(task, credits);
        }
        return pt.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(long credits) {
        Preconditions.checkArgument((credits >= 0L ? 1 : 0) != 0, (Object)"credits must be a non-negative number.");
        ArrayDeque<PendingTask<?>> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            Exceptions.checkNotClosed(this.closed, this);
            this.usedCredits = Math.max(0L, this.usedCredits - credits);
            log.trace("AsyncSemaphore[{}]: Release. Credits={}, TotalUsedCredits={}.", new Object[]{this.logId, credits, this.usedCredits});
        }
        ArrayList<PendingTask> toExecute = new ArrayList<PendingTask>();
        ArrayDeque<PendingTask<?>> arrayDeque2 = this.queue;
        synchronized (arrayDeque2) {
            while (!this.queue.isEmpty() && this.canExecute(this.queue.peekFirst().credits)) {
                PendingTask<?> qi = this.queue.removeFirst();
                this.usedCredits += qi.credits;
                toExecute.add(qi);
                log.debug("AsyncSemaphore[{}]: Task unblocked. Credits={}, TotalUsedCredits={}, QueueSize={}.", new Object[]{this.logId, qi.credits, this.usedCredits, this.queue.size()});
            }
        }
        toExecute.forEach(this::execute);
    }

    private <T> void execute(PendingTask<T> qi) {
        this.execute(qi.runTask, qi.credits).whenComplete((r, ex) -> {
            if (ex == null) {
                qi.result.complete(r);
            } else {
                qi.result.completeExceptionally((Throwable)ex);
            }
        });
    }

    private <T> CompletableFuture<T> execute(Supplier<CompletableFuture<T>> toExecute, long credits) {
        CompletableFuture<T> result;
        try {
            result = toExecute.get();
        }
        catch (Throwable ex2) {
            result = Futures.failedFuture(ex2);
        }
        Futures.exceptionListener(result, ex -> this.release(credits));
        return result;
    }

    @GuardedBy(value="queue")
    private boolean canExecute(long credits) {
        return this.usedCredits + credits <= this.totalCredits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayDeque<PendingTask<?>> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            return String.format("Credits = %d/%d, Tasks = %d", this.usedCredits, this.totalCredits, this.queue.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsedCredits() {
        ArrayDeque<PendingTask<?>> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            return this.usedCredits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getQueueSize() {
        ArrayDeque<PendingTask<?>> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            return this.queue.size();
        }
    }

    private static class PendingTask<T> {
        final long credits;
        final Supplier<CompletableFuture<T>> runTask;
        final CompletableFuture<T> result = new CompletableFuture();

        @ConstructorProperties(value={"credits", "runTask"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PendingTask(long credits, Supplier<CompletableFuture<T>> runTask) {
            this.credits = credits;
            this.runTask = runTask;
        }
    }
}

