/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.FieldDeserializer2;
import com.caucho.hessian.io.FieldDeserializer2FactoryUnsafe;
import com.caucho.hessian.io.HessianFieldException;
import com.caucho.hessian.io.JavaDeserializer;
import com.caucho.hessian.io.UnsafeDeserializer;
import com.caucho.hessian.io.UnsafeSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Logger;

public class FieldDeserializer2Factory {
    private static final Logger log = Logger.getLogger(JavaDeserializer.class.getName());

    public static FieldDeserializer2Factory create() {
        boolean isEnableUnsafeSerializer;
        boolean bl = isEnableUnsafeSerializer = UnsafeSerializer.isEnabled() && UnsafeDeserializer.isEnabled();
        if (isEnableUnsafeSerializer) {
            return new FieldDeserializer2FactoryUnsafe();
        }
        return new FieldDeserializer2Factory();
    }

    FieldDeserializer2 create(Field field) {
        if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            return NullFieldDeserializer.DESER;
        }
        try {
            field.setAccessible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Class<?> type = field.getType();
        FieldDeserializer2 deser = String.class.equals(type) ? new StringFieldDeserializer(field) : (Byte.TYPE.equals(type) ? new ByteFieldDeserializer(field) : (Short.TYPE.equals(type) ? new ShortFieldDeserializer(field) : (Integer.TYPE.equals(type) ? new IntFieldDeserializer(field) : (Long.TYPE.equals(type) ? new LongFieldDeserializer(field) : (Float.TYPE.equals(type) ? new FloatFieldDeserializer(field) : (Double.TYPE.equals(type) ? new DoubleFieldDeserializer(field) : (Boolean.TYPE.equals(type) ? new BooleanFieldDeserializer(field) : (Date.class.equals(type) ? new SqlDateFieldDeserializer(field) : (Timestamp.class.equals(type) ? new SqlTimestampFieldDeserializer(field) : (Time.class.equals(type) ? new SqlTimeFieldDeserializer(field) : new ObjectFieldDeserializer(field)))))))))));
        return deser;
    }

    protected static Object getParamArg(Class<?> cl) {
        if (!cl.isPrimitive()) {
            return null;
        }
        if (Boolean.TYPE.equals(cl)) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE.equals(cl)) {
            return new Byte(0);
        }
        if (Short.TYPE.equals(cl)) {
            return new Short(0);
        }
        if (Character.TYPE.equals(cl)) {
            return new Character('\u0000');
        }
        if (Integer.TYPE.equals(cl)) {
            return 0;
        }
        if (Long.TYPE.equals(cl)) {
            return 0L;
        }
        if (Float.TYPE.equals(cl)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(cl)) {
            return 0.0;
        }
        throw new UnsupportedOperationException();
    }

    static void logDeserializeError(Field field, Object obj, Object value, Throwable e) throws IOException {
        String fieldName = field.getDeclaringClass().getName() + "." + field.getName();
        if (e instanceof HessianFieldException) {
            throw (HessianFieldException)e;
        }
        if (e instanceof IOException) {
            throw new HessianFieldException(fieldName + ": " + e.getMessage(), e);
        }
        if (value != null) {
            throw new HessianFieldException(fieldName + ": " + value.getClass().getName() + " (" + value + ") cannot be assigned to '" + field.getType().getName() + "'", e);
        }
        throw new HessianFieldException(fieldName + ": " + field.getType().getName() + " cannot be assigned from null", e);
    }

    static class SqlTimeFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        SqlTimeFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Time value = null;
            try {
                java.util.Date date = (java.util.Date)in.readObject();
                if (date != null) {
                    value = new Time(date.getTime());
                    this._field.set(obj, value);
                } else {
                    this._field.set(obj, null);
                }
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class SqlTimestampFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        SqlTimestampFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Timestamp value = null;
            try {
                java.util.Date date = (java.util.Date)in.readObject();
                if (date != null) {
                    value = new Timestamp(date.getTime());
                    this._field.set(obj, value);
                } else {
                    this._field.set(obj, null);
                }
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class SqlDateFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        SqlDateFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Date value = null;
            try {
                java.util.Date date = (java.util.Date)in.readObject();
                if (date != null) {
                    value = new Date(date.getTime());
                    this._field.set(obj, value);
                } else {
                    this._field.set(obj, null);
                }
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class StringFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        StringFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            String value = null;
            try {
                value = in.readString();
                this._field.set(obj, value);
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class DoubleFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        DoubleFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            double value = 0.0;
            try {
                value = in.readDouble();
                this._field.setDouble(obj, value);
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class FloatFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        FloatFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            double value = 0.0;
            try {
                value = in.readDouble();
                this._field.setFloat(obj, (float)value);
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class LongFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        LongFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            long value = 0L;
            try {
                value = in.readLong();
                this._field.setLong(obj, value);
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class IntFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        IntFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            int value = 0;
            try {
                value = in.readInt();
                this._field.setInt(obj, value);
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class ShortFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        ShortFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            int value = 0;
            try {
                value = in.readInt();
                this._field.setShort(obj, (short)value);
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class ByteFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        ByteFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            int value = 0;
            try {
                value = in.readInt();
                this._field.setByte(obj, (byte)value);
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class BooleanFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        BooleanFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            boolean value = false;
            try {
                value = in.readBoolean();
                this._field.setBoolean(obj, value);
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class ObjectFieldDeserializer
    implements FieldDeserializer2 {
        private final Field _field;

        ObjectFieldDeserializer(Field field) {
            this._field = field;
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Object value = null;
            try {
                value = in.readObject(this._field.getType());
                this._field.set(obj, value);
            }
            catch (Exception e) {
                FieldDeserializer2Factory.logDeserializeError(this._field, obj, value, e);
            }
        }
    }

    static class NullFieldDeserializer
    implements FieldDeserializer2 {
        static NullFieldDeserializer DESER = new NullFieldDeserializer();

        NullFieldDeserializer() {
        }

        @Override
        public void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            in.readObject();
        }
    }
}

