/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc;

import org.apache.eventmesh.connector.jdbc.JdbcContext;
import org.apache.eventmesh.connector.jdbc.OffsetContext;
import org.apache.eventmesh.connector.jdbc.Partition;
import org.apache.eventmesh.connector.jdbc.PartitionOffSetContextPair;
import org.apache.eventmesh.connector.jdbc.ddl.DdlParser;
import org.apache.eventmesh.connector.jdbc.table.catalog.CatalogTableSet;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;

public abstract class UniversalJdbcContext<Part extends Partition, OffSetCtx extends OffsetContext, Parser extends DdlParser>
implements JdbcContext<Part, OffSetCtx> {
    private PartitionOffSetContextPair<Part, OffSetCtx> poCtx;
    private Parser parser;
    private CatalogTableSet tableSet = new CatalogTableSet();
    private volatile TableId tableId;

    public UniversalJdbcContext(PartitionOffSetContextPair<Part, OffSetCtx> poCtx, Parser parser) {
        this.poCtx = poCtx;
        this.parser = parser;
    }

    public UniversalJdbcContext(Part part, OffSetCtx offSetCtx, Parser parser) {
        this.poCtx = PartitionOffSetContextPair.of(part, offSetCtx);
        this.parser = parser;
    }

    @Override
    public Part getPartition() {
        return this.poCtx.getPartition();
    }

    @Override
    public OffSetCtx getOffsetContext() {
        return this.poCtx.getOffsetContext();
    }

    @Override
    public TableId ofCurrentTableId() {
        return this.tableId;
    }

    public Parser getParser() {
        return this.parser;
    }

    public CatalogTableSet getCatalogTableSet() {
        return this.tableSet;
    }

    public void withTableId(TableId tableId) {
        this.tableId = tableId;
    }
}

