/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.sink;

import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcConfig;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcSinkConfig;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.jdbc.JdbcConnectData;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialectFactory;
import org.apache.eventmesh.connector.jdbc.sink.handle.DefaultSinkRecordHandler;
import org.apache.eventmesh.connector.jdbc.sink.handle.SinkRecordHandler;
import org.apache.eventmesh.connector.jdbc.sink.hibernate.HibernateConfiguration;
import org.apache.eventmesh.connector.jdbc.source.JdbcAllFactoryLoader;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSinkConnector
implements Sink {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcSinkConnector.class);
    private JdbcSinkConfig sinkConfig;
    private SessionFactory sessionFactory;
    private DatabaseDialect<?> databaseDialect;
    private SinkRecordHandler sinkRecordHandler;

    public Class<? extends Config> configClass() {
        return JdbcSinkConfig.class;
    }

    public void init(Config config) throws Exception {
        if (!(config instanceof JdbcSinkConfig)) {
            throw new IllegalArgumentException("Config not be JdbcSinkConfig");
        }
        this.sinkConfig = (JdbcSinkConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (JdbcSinkConfig)sinkConnectorContext.getSinkConfig();
        this.doInit();
    }

    private void doInit() {
        JdbcConfig jdbcConfig = this.sinkConfig.getSinkConnectorConfig().getJdbcConfig();
        this.sessionFactory = HibernateConfiguration.newBuilder().withDruidMaxActive("20").withPassword(jdbcConfig.getPassword()).withUrl(jdbcConfig.getUrl()).withShowSql(true).withUser(jdbcConfig.getUser()).build();
        String databaseType = this.sinkConfig.getSinkConnectorConfig().getDatabaseType();
        DatabaseDialectFactory databaseDialectFactory = JdbcAllFactoryLoader.getDatabaseDialectFactory(databaseType);
        this.databaseDialect = databaseDialectFactory.createDatabaseDialect(this.sinkConfig.getSinkConnectorConfig().getJdbcConfig());
        Dialect dialect = ((SessionFactoryImplementor)this.sessionFactory.unwrap(SessionFactoryImplementor.class)).getJdbcServices().getDialect();
        this.databaseDialect.configure(dialect);
        this.databaseDialect.init();
        this.sinkRecordHandler = new DefaultSinkRecordHandler(this.databaseDialect, this.sessionFactory, this.sinkConfig);
    }

    public void start() throws Exception {
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getSinkConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() throws Exception {
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord record : sinkRecords) {
            Object data = record.getData();
            try {
                JdbcConnectData jdbcConnectData = (JdbcConnectData)JsonUtils.parseObject((byte[])((byte[])data), JdbcConnectData.class);
                this.sinkRecordHandler.handle(jdbcConnectData);
            }
            catch (Exception e) {
                log.error("Handle ConnectRecord error", (Throwable)e);
            }
        }
    }
}

