/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.sink.handle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.jdbc.CatalogChanges;
import org.apache.eventmesh.connector.jdbc.Field;
import org.apache.eventmesh.connector.jdbc.Schema;
import org.apache.eventmesh.connector.jdbc.dialect.AbstractGeneralDatabaseDialect;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.dialect.SqlStatementAssembler;
import org.apache.eventmesh.connector.jdbc.event.SchemaChangeEventType;
import org.apache.eventmesh.connector.jdbc.sink.handle.DialectAssemblyLine;
import org.apache.eventmesh.connector.jdbc.source.SourceMateData;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.Table;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.type.Type;
import org.hibernate.dialect.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralDialectAssemblyLine
implements DialectAssemblyLine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneralDialectAssemblyLine.class);
    private final DatabaseDialect<?> databaseDialect;
    private final Dialect hibernateDialect;

    public GeneralDialectAssemblyLine(DatabaseDialect<?> databaseDialect, Dialect hibernateDialect) {
        this.databaseDialect = databaseDialect;
        this.hibernateDialect = hibernateDialect;
    }

    @Override
    public String getDatabaseOrTableStatement(SourceMateData sourceMateData, CatalogChanges catalogChanges, String statement) {
        String type = catalogChanges.getType();
        String operationType = catalogChanges.getOperationType();
        SchemaChangeEventType schemaChangeEventType = SchemaChangeEventType.ofSchemaChangeEventType(type, operationType);
        String sql = null;
        switch (schemaChangeEventType) {
            case DATABASE_CREATE: {
                sql = this.assembleCreateDatabaseSql(catalogChanges);
                break;
            }
            case DATABASE_DROP: {
                sql = this.assembleDropDatabaseSql(catalogChanges);
                break;
            }
            case DATABASE_ALERT: {
                sql = this.assembleAlertDatabaseSql(catalogChanges);
                break;
            }
            case TABLE_CREATE: {
                sql = this.assembleCreateTableSql(catalogChanges);
                break;
            }
            case TABLE_DROP: {
                sql = this.assembleDropTableSql(catalogChanges);
                break;
            }
            case TABLE_ALERT: {
                sql = this.assembleAlertTableSql(catalogChanges);
                break;
            }
            default: {
                log.warn("Type={}, OperationType={} not support", (Object)type, (Object)operationType);
            }
        }
        return sql;
    }

    @Override
    public String getUpsertStatement(SourceMateData sourceMateData, Schema schema, String originStatement) {
        return null;
    }

    @Override
    public String getDeleteStatement(SourceMateData sourceMateData, Schema schema, String originStatement) {
        SqlStatementAssembler sqlStatementAssembler = new SqlStatementAssembler();
        sqlStatementAssembler.appendSqlSlice("DELETE FROM ").appendSqlSlice(((AbstractGeneralDatabaseDialect)this.databaseDialect).getQualifiedTableName(sourceMateData.ofTableId()));
        sqlStatementAssembler.appendSqlSlice(" WHERE ");
        if (schema.containsKey()) {
            sqlStatementAssembler.appendSqlSliceLists(" AND ", schema.getKeySet(), columnName -> columnName + " =?");
        } else {
            Field after = schema.getFields().get(0);
            sqlStatementAssembler.appendSqlSliceOfColumns(" AND ", after.getFields().stream().map(field -> field.getColumn()).sorted(Comparator.comparingInt(Column::getOrder)).collect(Collectors.toList()), column -> column.getName() + " =?");
        }
        return sqlStatementAssembler.build();
    }

    @Override
    public String getUpdateStatement(SourceMateData sourceMateData, Schema schema, String originStatement) {
        SqlStatementAssembler sqlStatementAssembler = new SqlStatementAssembler();
        TableId tableId = sourceMateData.ofTableId();
        Set<String> keySet = schema.getKeySet();
        Field tableColumns = schema.getFields().get(0);
        sqlStatementAssembler.appendSqlSlice("UPDATE ");
        sqlStatementAssembler.appendSqlSlice(((AbstractGeneralDatabaseDialect)this.databaseDialect).getQualifiedTableName(tableId));
        sqlStatementAssembler.appendSqlSlice(" SET ");
        sqlStatementAssembler.appendSqlSliceLists(", ", tableColumns.getFields().stream().map(Field::getColumn).sorted(Comparator.comparingInt(Column::getOrder)).filter(column -> !keySet.contains(column.getName())).map(column -> column.getName()).collect(Collectors.toList()), columnName -> columnName + " =?");
        if (schema.containsKey()) {
            sqlStatementAssembler.appendSqlSlice(" WHERE ");
            sqlStatementAssembler.appendSqlSliceLists(" AND ", keySet, columnName -> columnName + " =?");
        } else {
            sqlStatementAssembler.appendSqlSlice(" WHERE ");
            sqlStatementAssembler.appendSqlSliceOfColumns(" AND ", tableColumns.getFields().stream().map(field -> field.getColumn()).sorted(Comparator.comparingInt(Column::getOrder)).collect(Collectors.toList()), column -> column.getName() + " =?");
        }
        return sqlStatementAssembler.build();
    }

    @Override
    public String getInsertStatement(SourceMateData sourceMateData, Schema schema, String originStatement) {
        TableId tableId = sourceMateData.ofTableId();
        List afterFields = schema.getFields().stream().filter(field -> StringUtils.equals((CharSequence)field.getField(), (CharSequence)"after")).collect(Collectors.toList());
        SqlStatementAssembler sqlAssembler = new SqlStatementAssembler();
        sqlAssembler.appendSqlSlice("INSERT INTO ");
        sqlAssembler.appendSqlSlice(((AbstractGeneralDatabaseDialect)this.databaseDialect).getQualifiedTableName(tableId));
        sqlAssembler.appendSqlSlice(" (");
        Field afterField = (Field)afterFields.get(0);
        List<Column<?>> columns = afterField.getFields().stream().map(item -> item.getColumn()).sorted(Comparator.comparingInt(Column::getOrder)).collect(Collectors.toList());
        sqlAssembler.appendSqlSliceOfColumns(", ", columns, column -> column.getName());
        sqlAssembler.appendSqlSlice(") VALUES (");
        sqlAssembler.appendSqlSliceOfColumns(", ", columns, column -> this.getDmlBindingValue((Column<?>)column));
        sqlAssembler.appendSqlSlice(")");
        return sqlAssembler.build();
    }

    private String getDmlBindingValue(Column<?> column) {
        Type type = this.databaseDialect.getType(column);
        if (type == null) {
            return this.databaseDialect.getQueryBindingWithValueCast(column);
        }
        return type.getQueryBindingWithValue(this.databaseDialect, column);
    }

    private String assembleCreateDatabaseSql(CatalogChanges catalogChanges) {
        SqlStatementAssembler assembler = new SqlStatementAssembler();
        assembler.appendSqlSlice("CREATE DATABASE IF NOT EXISTS ");
        assembler.appendSqlSlice(((AbstractGeneralDatabaseDialect)this.databaseDialect).getQualifiedText(catalogChanges.getCatalog().getName()));
        return assembler.build();
    }

    private String assembleDropDatabaseSql(CatalogChanges catalogChanges) {
        SqlStatementAssembler assembler = new SqlStatementAssembler();
        assembler.appendSqlSlice("DROP DATABASE IF EXISTS ");
        assembler.appendSqlSlice(((AbstractGeneralDatabaseDialect)this.databaseDialect).getQualifiedText(catalogChanges.getCatalog().getName()));
        return assembler.build();
    }

    private String assembleAlertDatabaseSql(CatalogChanges catalogChanges) {
        SqlStatementAssembler assembler = new SqlStatementAssembler();
        return assembler.build();
    }

    private String assembleCreateTableSql(CatalogChanges catalogChanges) {
        SqlStatementAssembler assembler = new SqlStatementAssembler();
        assembler.appendSqlSlice("CREATE TABLE IF NOT EXISTS ");
        Table table = catalogChanges.getTable();
        assembler.appendSqlSlice(((AbstractGeneralDatabaseDialect)this.databaseDialect).getQualifiedTableName(table.getTableId()));
        assembler.appendSqlSlice(" (");
        List columns = catalogChanges.getColumns().stream().sorted(Comparator.comparingInt(Column::getOrder)).collect(Collectors.toList());
        List<String> columnNames = columns.stream().map(item -> item.getName()).collect(Collectors.toList());
        Map<String, Column> columnMap = columns.stream().collect(Collectors.toMap(Column::getName, item -> item));
        assembler.appendSqlSliceLists(", ", columnNames, columnName -> {
            StringBuilder builder = new StringBuilder();
            builder.append(((AbstractGeneralDatabaseDialect)this.databaseDialect).getQualifiedText((String)columnName));
            Column column = (Column)columnMap.get(columnName);
            String typeName = this.databaseDialect.getTypeName(this.hibernateDialect, column);
            builder.append(" ").append(typeName);
            builder.append(" ").append(this.databaseDialect.getCharsetOrCollateFormatted(column));
            if (((List)Optional.ofNullable(table.getPrimaryKey().getColumnNames()).orElse(new ArrayList(0))).contains(columnName)) {
                builder.append(" NOT NULL ");
                if (column.isAutoIncremented()) {
                    builder.append(this.databaseDialect.getAutoIncrementFormatted(column));
                }
            } else if (column.isNotNull()) {
                builder.append(" NOT NULL ");
            }
            this.addColumnDefaultValue(column, builder);
            builder.append(" ").append(this.databaseDialect.getCommentFormatted(column));
            return builder.toString();
        });
        assembler.appendSqlSlice(", PRIMARY KEY(");
        assembler.appendSqlSliceLists(",", catalogChanges.getTable().getPrimaryKey().getColumnNames(), columnName -> ((AbstractGeneralDatabaseDialect)this.databaseDialect).getQualifiedText((String)columnName));
        assembler.appendSqlSlice(")");
        assembler.appendSqlSlice(")");
        assembler.appendSqlSlice(this.databaseDialect.getTableOptionsFormatted(catalogChanges.getTable()));
        return assembler.build();
    }

    private void addColumnDefaultValue(Column<?> column, StringBuilder builder) {
        if (column.isNotNull() && column.getDefaultValue() == null) {
            return;
        }
        String defaultValueFormatted = this.databaseDialect.getDefaultValueFormatted(column);
        if (StringUtils.isNotEmpty((CharSequence)defaultValueFormatted)) {
            builder.append(" DEFAULT ").append(defaultValueFormatted);
        }
    }

    private String assembleDropTableSql(CatalogChanges catalogChanges) {
        SqlStatementAssembler assembler = new SqlStatementAssembler();
        assembler.appendSqlSlice("DROP TABLE IF EXISTS ");
        assembler.appendSqlSlice(((AbstractGeneralDatabaseDialect)this.databaseDialect).getQualifiedTableName(catalogChanges.getTable().getTableId()));
        return assembler.build();
    }

    private String assembleAlertTableSql(CatalogChanges catalogChanges) {
        SqlStatementAssembler assembler = new SqlStatementAssembler();
        return assembler.build();
    }

    @Generated
    public DatabaseDialect<?> getDatabaseDialect() {
        return this.databaseDialect;
    }

    @Generated
    public Dialect getHibernateDialect() {
        return this.hibernateDialect;
    }
}

