/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source;

import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.SourceConfig;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcSourceConfig;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialectFactory;
import org.apache.eventmesh.connector.jdbc.event.Event;
import org.apache.eventmesh.connector.jdbc.source.EventDispatcher;
import org.apache.eventmesh.connector.jdbc.source.JdbcAllFactoryLoader;
import org.apache.eventmesh.connector.jdbc.source.SourceJdbcTaskManager;
import org.apache.eventmesh.connector.jdbc.source.TaskManagerCoordinator;
import org.apache.eventmesh.connector.jdbc.source.dialect.cdc.CdcEngine;
import org.apache.eventmesh.connector.jdbc.source.dialect.cdc.CdcEngineFactory;
import org.apache.eventmesh.connector.jdbc.source.dialect.snapshot.SnapshotEngine;
import org.apache.eventmesh.connector.jdbc.source.dialect.snapshot.SnapshotEngineFactory;
import org.apache.eventmesh.connector.jdbc.source.dialect.snapshot.SnapshotResult;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnector;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSourceConnector
extends SourceConnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcSourceConnector.class);
    private DatabaseDialect databaseDialect;
    private CdcEngine cdcEngine;
    private JdbcSourceConfig sourceConfig;
    private EventDispatcher dispatcher;
    private SourceJdbcTaskManager sourceJdbcTaskManager;
    private SnapshotEngine<?> snapshotEngine;
    private TaskManagerCoordinator taskManagerCoordinator;

    public JdbcSourceConnector() {
        this(null);
    }

    protected JdbcSourceConnector(SourceConfig sourceConfig) {
        super(sourceConfig);
    }

    public Class<? extends Config> configClass() {
        return JdbcSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        if (!(config instanceof JdbcSourceConfig)) {
            throw new IllegalArgumentException("Config not be JdbcSourceConfig");
        }
        this.sourceConfig = (JdbcSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (JdbcSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        String databaseType = this.sourceConfig.getSourceConnectorConfig().getDatabaseType();
        DatabaseDialectFactory databaseDialectFactory = JdbcAllFactoryLoader.getDatabaseDialectFactory(databaseType);
        this.databaseDialect = databaseDialectFactory.createDatabaseDialect(this.sourceConfig.getSourceConnectorConfig().getJdbcConfig());
        this.databaseDialect.init();
        SnapshotEngineFactory snapshotEngineFactory = JdbcAllFactoryLoader.getSnapshotEngineFactory(databaseType);
        this.snapshotEngine = snapshotEngineFactory.createSnapshotEngine(this.sourceConfig, this.databaseDialect);
        this.snapshotEngine.registerSnapshotEventConsumer(this::eventConsumer);
        this.snapshotEngine.init();
        CdcEngineFactory cdcEngineFactory = JdbcAllFactoryLoader.getCdcEngineFactory(databaseType);
        if (!cdcEngineFactory.acceptJdbcProtocol(this.databaseDialect.jdbcProtocol())) {
            throw new IllegalArgumentException("CdcEngineFactory not supports " + databaseType);
        }
        this.cdcEngine = cdcEngineFactory.createCdcEngine((SourceConfig)this.sourceConfig, this.databaseDialect);
        if (CollectionUtils.isEmpty(this.cdcEngine.getHandledTables())) {
            throw new RuntimeException("No database tables need to be processed");
        }
        this.cdcEngine.registerCdcEventConsumer(this::eventConsumer);
        this.cdcEngine.init();
        Set<TableId> handledTables = this.snapshotEngine.getHandledTables();
        this.sourceJdbcTaskManager = new SourceJdbcTaskManager(handledTables, this.sourceConfig);
        this.sourceJdbcTaskManager.init();
        this.dispatcher = new EventDispatcher(this.sourceJdbcTaskManager);
        this.taskManagerCoordinator = new TaskManagerCoordinator(this.sourceConfig.getPollConfig().getCapacity(), this.sourceConfig.getPollConfig().getMaxBatchSize(), this.sourceConfig.getPollConfig().getMaxWaitTime());
        this.taskManagerCoordinator.registerTaskManager(SourceJdbcTaskManager.class.getName(), this.sourceJdbcTaskManager);
        this.taskManagerCoordinator.init();
    }

    private void eventConsumer(Event event) {
        this.dispatcher.dispatch(event);
    }

    public void start() throws Exception {
        this.databaseDialect.start();
        this.taskManagerCoordinator.start();
        this.snapshotEngine.start();
        SnapshotResult<?> result = this.snapshotEngine.execute();
        this.snapshotEngine.close();
        if (result.getStatus() != SnapshotResult.SnapshotResultStatus.ABORTED) {
            log.info("Start Cdc Engine to handle cdc event");
            this.cdcEngine.setContext(result.getContext());
            this.cdcEngine.start();
        }
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return "JDBC Source Connector";
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() throws Exception {
    }

    public List<ConnectRecord> poll() {
        return this.taskManagerCoordinator.poll();
    }
}

