/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.cdc.mysql;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.GtidSet;
import com.github.shyiko.mysql.binlog.event.DeleteRowsEventData;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeader;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.TransactionPayloadEventData;
import com.github.shyiko.mysql.binlog.event.UpdateRowsEventData;
import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import com.github.shyiko.mysql.binlog.event.XidEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializationException;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.SourceConfig;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcConfig;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcSourceConfig;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.MysqlConfig;
import org.apache.eventmesh.connector.jdbc.CatalogChanges;
import org.apache.eventmesh.connector.jdbc.DataChanges;
import org.apache.eventmesh.connector.jdbc.Field;
import org.apache.eventmesh.connector.jdbc.Payload;
import org.apache.eventmesh.connector.jdbc.Schema;
import org.apache.eventmesh.connector.jdbc.connection.mysql.MysqlJdbcConnection;
import org.apache.eventmesh.connector.jdbc.dialect.mysql.MysqlDatabaseDialect;
import org.apache.eventmesh.connector.jdbc.event.DeleteDataEvent;
import org.apache.eventmesh.connector.jdbc.event.Event;
import org.apache.eventmesh.connector.jdbc.event.EventConsumer;
import org.apache.eventmesh.connector.jdbc.event.GeneralDataChangeEvent;
import org.apache.eventmesh.connector.jdbc.event.InsertDataEvent;
import org.apache.eventmesh.connector.jdbc.event.SchemaChangeEventType;
import org.apache.eventmesh.connector.jdbc.event.UpdateDataEvent;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.MysqlAntlr4DdlParser;
import org.apache.eventmesh.connector.jdbc.source.dialect.cdc.AbstractCdcEngine;
import org.apache.eventmesh.connector.jdbc.source.dialect.cdc.mysql.RowDeserializers;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.EventDataDeserializationExceptionData;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.EventMeshGtidSet;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlConstants;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlJdbcContext;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlSourceMateData;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.DefaultValueConvertor;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableSchema;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlDefaultValueConvertorImpl;
import org.apache.eventmesh.connector.jdbc.table.type.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlCdcEngine
extends AbstractCdcEngine<MysqlAntlr4DdlParser, MysqlJdbcContext, MysqlDatabaseDialect> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MysqlCdcEngine.class);
    private BinaryLogClient client;
    private BlockingQueue<com.github.shyiko.mysql.binlog.event.Event> eventQueue = new LinkedBlockingQueue<com.github.shyiko.mysql.binlog.event.Event>(10000);
    private final EnumMap<EventType, Consumer<com.github.shyiko.mysql.binlog.event.Event>> eventHandlers = new EnumMap(EventType.class);
    private Map<Long, TableId> tableIdMap = new HashMap<Long, TableId>(64);
    private MysqlJdbcContext context;
    private List<EventConsumer> consumers = new ArrayList<EventConsumer>(16);
    private MysqlAntlr4DdlParser ddlParser;
    private MysqlJdbcConnection connection;
    private GtidSet localGtidSet;
    private DefaultValueConvertor defaultValueConvertor = new MysqlDefaultValueConvertorImpl();

    public MysqlCdcEngine(Config config, MysqlDatabaseDialect databaseDialect) {
        super((SourceConfig)((JdbcSourceConfig)config), databaseDialect);
        this.ddlParser = new MysqlAntlr4DdlParser(false, false, this.getHandledTables(), (JdbcSourceConfig)config);
        this.connection = databaseDialect.getConnection();
    }

    @Override
    public void init() {
        JdbcConfig jdbcConfig = this.sourceConnectorConfig.getJdbcConfig();
        this.client = new BinaryLogClient(jdbcConfig.getHostname(), jdbcConfig.getPort(), jdbcConfig.getUser(), jdbcConfig.getPassword());
        this.client.setThreadFactory((ThreadFactory)new EventMeshThreadFactory("mysql-binlog-client"));
        MysqlConfig mysqlConfig = this.sourceConnectorConfig.getMysqlConfig();
        this.client.setServerId((long)mysqlConfig.getServerId());
        this.client.setKeepAlive(mysqlConfig.isKeepAlive());
        long keepAliveInterval = mysqlConfig.getKeepAliveInterval();
        this.client.setKeepAliveInterval(keepAliveInterval);
        final HashMap<Long, TableMapEventData> tableMapEventByTableId = new HashMap<Long, TableMapEventData>(32);
        EventDeserializer eventDeserializer = new EventDeserializer(){

            public com.github.shyiko.mysql.binlog.event.Event nextEvent(ByteArrayInputStream inputStream) throws IOException {
                try {
                    com.github.shyiko.mysql.binlog.event.Event event = super.nextEvent(inputStream);
                    log.debug("MYSQL Binlog---EventType={}, EventData={}", (Object)event.getHeader().getEventType(), (Object)event);
                    if (event.getHeader().getEventType() == EventType.TABLE_MAP) {
                        TableMapEventData tableMapEvent = (TableMapEventData)event.getData();
                        tableMapEventByTableId.put(tableMapEvent.getTableId(), tableMapEvent);
                    }
                    if (event.getHeader().getEventType() == EventType.TRANSACTION_PAYLOAD) {
                        TransactionPayloadEventData transactionPayloadEventData = (TransactionPayloadEventData)event.getData();
                        for (com.github.shyiko.mysql.binlog.event.Event uncompressedEvent : transactionPayloadEventData.getUncompressedEvents()) {
                            if (uncompressedEvent.getHeader().getEventType() != EventType.TABLE_MAP || uncompressedEvent.getData() == null) continue;
                            TableMapEventData tableMapEvent = (TableMapEventData)uncompressedEvent.getData();
                            tableMapEventByTableId.put(tableMapEvent.getTableId(), tableMapEvent);
                        }
                    }
                    if (event.getHeader().getEventType() == EventType.ROTATE) {
                        tableMapEventByTableId.clear();
                    }
                    return event;
                }
                catch (EventDataDeserializationException ex) {
                    if (ex.getCause() instanceof IOException) {
                        throw ex;
                    }
                    EventHeaderV4 header = new EventHeaderV4();
                    header.setEventType(EventType.INCIDENT);
                    header.setTimestamp(ex.getEventHeader().getTimestamp());
                    header.setServerId(ex.getEventHeader().getServerId());
                    if (ex.getEventHeader() instanceof EventHeaderV4) {
                        header.setEventLength(((EventHeaderV4)ex.getEventHeader()).getEventLength());
                        header.setNextPosition(((EventHeaderV4)ex.getEventHeader()).getNextPosition());
                        header.setFlags(((EventHeaderV4)ex.getEventHeader()).getFlags());
                    }
                    EventDataDeserializationExceptionData data = new EventDataDeserializationExceptionData(ex);
                    return new com.github.shyiko.mysql.binlog.event.Event((EventHeader)header, (EventData)data);
                }
            }
        };
        eventDeserializer.setEventDataDeserializer(EventType.WRITE_ROWS, (EventDataDeserializer)new RowDeserializers.WriteRowsEventMeshDeserializer(tableMapEventByTableId));
        eventDeserializer.setEventDataDeserializer(EventType.UPDATE_ROWS, (EventDataDeserializer)new RowDeserializers.UpdateRowsEventMeshDeserializer(tableMapEventByTableId));
        eventDeserializer.setEventDataDeserializer(EventType.DELETE_ROWS, (EventDataDeserializer)new RowDeserializers.DeleteRowsEventMeshDeserializer(tableMapEventByTableId));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_WRITE_ROWS, (EventDataDeserializer)new RowDeserializers.WriteRowsEventMeshDeserializer(tableMapEventByTableId).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_UPDATE_ROWS, (EventDataDeserializer)new RowDeserializers.UpdateRowsEventMeshDeserializer(tableMapEventByTableId).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_DELETE_ROWS, (EventDataDeserializer)new RowDeserializers.DeleteRowsEventMeshDeserializer(tableMapEventByTableId).setMayContainExtraInformation(true));
        this.client.setEventDeserializer(eventDeserializer);
        this.client.registerEventListener(event -> this.eventMeshMysqlEventListener(event, this.context));
        this.client.registerLifecycleListener(new BinaryLogClient.LifecycleListener(){

            public void onConnect(BinaryLogClient client) {
                log.info("Client connect MySQL Server success");
            }

            public void onCommunicationFailure(BinaryLogClient client, Exception ex) {
                log.error("Communicate with mysql error", (Throwable)ex);
            }

            public void onEventDeserializationFailure(BinaryLogClient client, Exception ex) {
                log.error("Event deserialization failure", (Throwable)ex);
            }

            public void onDisconnect(BinaryLogClient client) {
                log.info("Disconnect Mysql");
            }
        });
        this.eventHandlers.put(EventType.STOP, event -> this.handleStopEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.HEARTBEAT, event -> this.handleHeartbeatEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.INCIDENT, event -> this.handleServerIncident(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.ROTATE, event -> this.handleRotateEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.TABLE_MAP, event -> this.handleTableMapEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.QUERY, event -> this.handleQueryEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.TRANSACTION_PAYLOAD, event -> this.handleTransactionPayload(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.WRITE_ROWS, event -> this.handleInsertEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.UPDATE_ROWS, event -> this.handleUpdateEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.DELETE_ROWS, event -> this.handleDeleteEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.EXT_WRITE_ROWS, event -> this.handleInsertEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.EXT_UPDATE_ROWS, event -> this.handleUpdateEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.EXT_DELETE_ROWS, event -> this.handleDeleteEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.VIEW_CHANGE, event -> this.handleViewChangeEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.XA_PREPARE, event -> this.handleXAPrepareTransactionEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
        this.eventHandlers.put(EventType.XID, event -> this.handleTransactionCompletionEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
    }

    public EventMeshGtidSet filterGtidSet(MysqlJdbcContext offsetContext, EventMeshGtidSet availableServerEventMeshGtidSet, EventMeshGtidSet purgedServerGtid) {
        EventMeshGtidSet filteredEventMeshGtidSet;
        String gtidStr = offsetContext.getGtidSet();
        if (gtidStr == null) {
            return null;
        }
        EventMeshGtidSet knownEventMeshGtidSet = filteredEventMeshGtidSet = new EventMeshGtidSet(gtidStr);
        EventMeshGtidSet relevantAvailableServerEventMeshGtidSet = availableServerEventMeshGtidSet;
        EventMeshGtidSet mergedEventMeshGtidSet = relevantAvailableServerEventMeshGtidSet.retainAll(uuid -> knownEventMeshGtidSet.forServerWithId((String)uuid) != null).with(purgedServerGtid).with(filteredEventMeshGtidSet);
        return mergedEventMeshGtidSet;
    }

    private void eventMeshMysqlEventListener(com.github.shyiko.mysql.binlog.event.Event event, MysqlJdbcContext context) {
        if (event == null) {
            return;
        }
        EventHeader eventHeader = event.getHeader();
        EventType eventType = eventHeader.getEventType();
        if (eventType == EventType.ROTATE) {
            RotateEventData rotateEventData = (RotateEventData)this.unwrapData(event);
            context.setBinlogStartPoint(rotateEventData.getBinlogFilename(), rotateEventData.getBinlogPosition());
        } else if (eventHeader instanceof EventHeaderV4) {
            EventHeaderV4 eventHeaderV4 = (EventHeaderV4)eventHeader;
            context.setEventPosition(eventHeaderV4.getPosition(), eventHeaderV4.getEventLength());
        }
        if (eventType == EventType.HEARTBEAT) {
            return;
        }
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            log.warn("Put event to queue error", (Throwable)e);
        }
        context.complete();
    }

    public String getThreadName() {
        return "MySQL-CdcEngine";
    }

    @Override
    public String getCdcEngineName() {
        return "MySQL CDC Engine";
    }

    @Override
    public void close() throws Exception {
        this.client.disconnect();
    }

    public void run() {
        this.enableGtidHandle();
        do {
            try {
                this.client.connect(TimeUnit.SECONDS.toMillis(5L));
            }
            catch (IOException | TimeoutException e) {
                log.error("Binary log client connect to mysql server error, The connection will be retried in three seconds", (Throwable)e);
                this.await(3L, TimeUnit.SECONDS);
            }
        } while (!this.client.isConnected());
        while (this.isRunning) {
            com.github.shyiko.mysql.binlog.event.Event event = null;
            try {
                event = this.eventQueue.poll(5L, TimeUnit.SECONDS);
                if (event == null) continue;
                this.eventHandlers.getOrDefault(event.getHeader().getEventType(), ignore -> this.ignoreEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)ignore)).accept(event);
            }
            catch (Exception e) {
                if (event == null) continue;
                log.warn("Handle EventType={} error", (Object)event.getHeader().getEventType(), (Object)e);
            }
        }
    }

    private void enableGtidHandle() {
        if (this.connection.enableGTID()) {
            this.eventHandlers.put(EventType.GTID, event -> this.handleGtidEvent(this.context, (com.github.shyiko.mysql.binlog.event.Event)event));
            String availableServerGtid = this.connection.executedGTID();
            EventMeshGtidSet executedEventMeshGtidSet = new EventMeshGtidSet(availableServerGtid);
            String purgedServerGtid = this.connection.purgedGTID();
            EventMeshGtidSet purgedServerEventMeshGtidSet = new EventMeshGtidSet(purgedServerGtid);
            EventMeshGtidSet filteredEventMeshGtidSet = this.filterGtidSet(this.context, executedEventMeshGtidSet, purgedServerEventMeshGtidSet);
            if (filteredEventMeshGtidSet != null) {
                this.client.setGtidSet(filteredEventMeshGtidSet.toString());
                this.context.completedGtidSet(filteredEventMeshGtidSet.toString());
                this.localGtidSet = new GtidSet(filteredEventMeshGtidSet.toString());
            } else {
                this.client.setBinlogFilename(this.context.getSourceInfo().getCurrentBinlogFileName());
                this.client.setBinlogPosition(this.context.getSourceInfo().getCurrentBinlogPosition());
                this.localGtidSet = new GtidSet("");
            }
        } else {
            this.client.setBinlogFilename(this.context.getSourceInfo().getCurrentBinlogFileName());
            this.client.setBinlogPosition(this.context.getSourceInfo().getCurrentBinlogPosition());
        }
    }

    protected void handleStopEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        log.debug("Replication client has reached the end of the binary log: {}", (Object)event);
    }

    protected void handleHeartbeatEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        log.debug("Replication client handle {}", (Object)event.getHeader().getEventType());
    }

    protected void handleServerIncident(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        EventData eventData = event.getData();
        if (eventData instanceof EventDataDeserializationExceptionData) {
            log.error("Server incident: {}", (Object)event);
        }
    }

    protected void handleRotateEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        RotateEventData eventData = (RotateEventData)this.unwrapData(event);
        assert (eventData != null);
        this.tableIdMap.clear();
    }

    protected <T extends EventData> T unwrapData(com.github.shyiko.mysql.binlog.event.Event event) {
        EventData eventData = event.getData();
        if (eventData instanceof EventDeserializer.EventDataWrapper) {
            eventData = ((EventDeserializer.EventDataWrapper)eventData).getInternal();
        }
        return (T)eventData;
    }

    protected void handleTableMapEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        TableMapEventData tableMapEventData = (TableMapEventData)event.getData();
        long tableId = tableMapEventData.getTableId();
        String tableName = tableMapEventData.getTable();
        String database = tableMapEventData.getDatabase();
        this.tableIdMap.put(tableId, new TableId(database, null, tableName));
    }

    protected void handleQueryEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        QueryEventData queryEventData = (QueryEventData)this.unwrapData(event);
        String sql = queryEventData.getSql().trim();
        log.debug("Received query event SQL:{}", (Object)sql);
        if (StringUtils.equalsIgnoreCase((CharSequence)"BEGIN", (CharSequence)sql)) {
            context.startTransaction();
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"COMMIT", (CharSequence)sql)) {
            context.commitTransaction();
            return;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)"XA", (CharSequence)sql)) {
            return;
        }
        String sqlBegin = sql.substring(0, 6).toUpperCase();
        if (StringUtils.startsWithAny((CharSequence)sqlBegin, (CharSequence[])new CharSequence[]{"INSERT", "UPDATE", "DELETE"})) {
            log.warn("Received DML '[SQL={}]' for processing, binlog probably contains events generated with statement", (Object)sql);
            return;
        }
        this.ddlParser.setCurrentDatabase(queryEventData.getDatabase());
        this.ddlParser.setCatalogTableSet(context.getCatalogTableSet());
        this.ddlParser.parse(sql, this::handleDdlEvent);
    }

    private void handleDdlEvent(Event event) {
        CatalogChanges catalogChanges;
        SchemaChangeEventType schemaChangeEventType;
        if (event == null) {
            return;
        }
        if (event.getJdbcConnectData().isSchemaChanges() && (SchemaChangeEventType.TABLE_CREATE == (schemaChangeEventType = SchemaChangeEventType.ofSchemaChangeEventType((catalogChanges = event.getJdbcConnectData().getPayload().getCatalogChanges()).getType(), catalogChanges.getOperationType())) || SchemaChangeEventType.TABLE_ALERT == schemaChangeEventType)) {
            catalogChanges.getColumns().forEach(column -> column.setDefaultValue(this.defaultValueConvertor.parseDefaultValue((Column<?>)column, column.getDefaultValueExpression())));
        }
        event.getJdbcConnectData().getPayload().ofSourceMateData().setSnapshot(false);
        this.consumers.stream().forEach(consumer -> consumer.accept(event));
    }

    protected void handleTransactionPayload(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        TransactionPayloadEventData transactionPayloadEventData = (TransactionPayloadEventData)event.getData();
        ArrayList uncompressedEvents = transactionPayloadEventData.getUncompressedEvents();
        for (com.github.shyiko.mysql.binlog.event.Event uncompressedEvent : uncompressedEvents) {
            EventType eventType = uncompressedEvent.getHeader().getEventType();
            this.eventHandlers.getOrDefault(eventType, et -> this.ignoreEvent(context, (com.github.shyiko.mysql.binlog.event.Event)et)).accept(uncompressedEvent);
        }
    }

    protected void handleInsertEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        WriteRowsEventData writeRowsEventData = (WriteRowsEventData)this.unwrapData(event);
        log.debug("Received Write rows event, TableId={}", (Object)writeRowsEventData.getTableId());
        long tableNumber = writeRowsEventData.getTableId();
        TableId tableId = this.tableIdMap.get(tableNumber);
        if (!this.getHandledTables().contains(tableId)) {
            log.warn("Write rows-Table {} is excluded", (Object)tableId);
            return;
        }
        MysqlSourceMateData sourceMateData = this.buildMysqlSourceMateData(context, event, tableId);
        List insertRows = writeRowsEventData.getRows();
        if (CollectionUtils.isEmpty((Collection)insertRows)) {
            return;
        }
        ArrayList<Pair<Pair<Serializable[], BitSet>, Pair<Serializable[], BitSet>>> rows = new ArrayList<Pair<Pair<Serializable[], BitSet>, Pair<Serializable[], BitSet>>>();
        for (Serializable[] row : insertRows) {
            Pair<Serializable[], BitSet> item = new Pair<Serializable[], BitSet>(row, writeRowsEventData.getIncludedColumns());
            rows.add(new Pair<Object, Pair<Serializable[], BitSet>>(null, item));
        }
        this.handleCdcDmlData(context, sourceMateData, tableId, rows, CdcDmlType.INSERT);
    }

    private MysqlSourceMateData buildMysqlSourceMateData(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event, TableId tableId) {
        MysqlSourceMateData sourceMateData = MysqlSourceMateData.newBuilder().name(this.sourceConnectorConfig.getName()).withTableId(tableId).serverId(this.sourceConnectorConfig.getMysqlConfig().getServerId()).binlogFile(context.getSourceInfo().getCurrentBinlogFileName()).position(((EventHeaderV4)event.getHeader()).getPosition()).build();
        return sourceMateData;
    }

    private GeneralDataChangeEvent buildEvent(CdcDmlType type, TableId tableId) {
        switch (type) {
            case UPDATE: {
                return new UpdateDataEvent(tableId);
            }
            case INSERT: {
                return new InsertDataEvent(tableId);
            }
            case DELETE: {
                return new DeleteDataEvent(tableId);
            }
        }
        return null;
    }

    private void handleCdcDmlData(MysqlJdbcContext context, MysqlSourceMateData sourceMateData, TableId tableId, List<Pair<Pair<Serializable[], BitSet>, Pair<Serializable[], BitSet>>> rows, CdcDmlType type) {
        TableSchema tableSchema = context.getCatalogTableSet().getTableSchema(tableId);
        Map<Integer, Column<?>> orderColumnMap = tableSchema.getOrderColumnMap();
        List<Column<?>> columns = tableSchema.getColumns();
        List<Field> fields = null;
        DataChanges.Builder builder = DataChanges.newBuilder();
        if (CollectionUtils.isNotEmpty(columns)) {
            fields = columns.stream().map(col -> {
                Column rebuild = Column.newBuilder().withName(col.getName()).withDataType(col.getDataType()).withJdbcType(col.getJdbcType()).withNativeType(col.getNativeType()).withOrder(col.getOrder()).build();
                return new Field(rebuild, col.isNotNull(), col.getName(), tableId.toString());
            }).collect(Collectors.toList());
        }
        int columnsSize = orderColumnMap.size();
        for (Pair<Pair<Serializable[], BitSet>, Pair<Serializable[], BitSet>> pair : rows) {
            Pair afterPair;
            Serializable[] afterRows;
            GeneralDataChangeEvent dataEvent = this.buildEvent(type, tableId);
            builder.withType(dataEvent.getDataChangeEventType().ofCode());
            Schema schema = new Schema();
            schema.addKeys(tableSchema.getPrimaryKey().getColumnNames());
            Pair beforePair = Optional.ofNullable(pair.getLeft()).orElse(new Pair());
            Serializable[] beforeRows = (Serializable[])beforePair.getLeft();
            if (beforeRows != null && beforeRows.length != 0) {
                BitSet includedColumns = (BitSet)beforePair.getRight();
                HashMap<String, Serializable> beforeValues = new HashMap<String, Serializable>(beforeRows.length);
                for (int index = 0; index < columnsSize; ++index) {
                    if (!includedColumns.get(index)) continue;
                    beforeValues.put(orderColumnMap.get(index + 1).getName(), beforeRows[index]);
                }
                builder.withBefore(beforeValues);
                Field beforeField = new Field().withField("before").withName("payload.before").withRequired(false);
                beforeField.withRequired(true).withFields(fields);
                schema.add(beforeField);
            }
            if ((afterRows = (Serializable[])(afterPair = Optional.ofNullable(pair.getRight()).orElse(new Pair())).getLeft()) != null && afterRows.length != 0) {
                BitSet includedColumns = (BitSet)afterPair.getRight();
                HashMap<String, Serializable> afterValues = new HashMap<String, Serializable>(afterRows.length);
                for (int index = 0; index < columnsSize; ++index) {
                    if (!includedColumns.get(index)) continue;
                    afterValues.put(orderColumnMap.get(index + 1).getName(), afterRows[index]);
                }
                builder.withAfter(afterValues);
                Field afterField = new Field().withField("after").withName("payload.after").withRequired(false);
                afterField.withRequired(true).withFields(fields);
                schema.add(afterField);
            }
            Payload payload = dataEvent.getJdbcConnectData().getPayload();
            payload.withSource(sourceMateData).withDataChanges(builder.build());
            dataEvent.getJdbcConnectData().setSchema(schema);
            this.consumers.stream().forEach(consumer -> consumer.accept(dataEvent));
        }
    }

    protected void handleUpdateEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        UpdateRowsEventData updateRowsEventData = (UpdateRowsEventData)this.unwrapData(event);
        log.debug("Received Update rows event, Update table is {}", (Object)this.tableIdMap.get(updateRowsEventData.getTableId()));
        long id = updateRowsEventData.getTableId();
        TableId tableId = this.tableIdMap.get(id);
        if (!this.getHandledTables().contains(tableId)) {
            log.debug("Update rows-Table {} is excluded", (Object)tableId);
            return;
        }
        MysqlSourceMateData sourceMateData = this.buildMysqlSourceMateData(context, event, tableId);
        List updateRows = updateRowsEventData.getRows();
        if (CollectionUtils.isEmpty((Collection)updateRows)) {
            return;
        }
        ArrayList<Pair<Pair<Serializable[], BitSet>, Pair<Serializable[], BitSet>>> rows = new ArrayList<Pair<Pair<Serializable[], BitSet>, Pair<Serializable[], BitSet>>>();
        for (Map.Entry row : updateRows) {
            Pair before = new Pair(row.getKey(), updateRowsEventData.getIncludedColumnsBeforeUpdate());
            Pair after = new Pair(row.getValue(), updateRowsEventData.getIncludedColumns());
            rows.add(new Pair(before, after));
        }
        this.handleCdcDmlData(context, sourceMateData, tableId, rows, CdcDmlType.UPDATE);
    }

    protected void handleDeleteEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        DeleteRowsEventData deleteRowsEventData = (DeleteRowsEventData)this.unwrapData(event);
        log.debug("Received Delete rows event, Delete table is {}", (Object)this.tableIdMap.get(deleteRowsEventData.getTableId()));
        long id = deleteRowsEventData.getTableId();
        TableId tableId = this.tableIdMap.get(id);
        if (!this.getHandledTables().contains(tableId)) {
            log.debug("Update rows-Table {} is excluded", (Object)tableId);
            return;
        }
        MysqlSourceMateData sourceMateData = this.buildMysqlSourceMateData(context, event, tableId);
        List deleteRows = deleteRowsEventData.getRows();
        if (CollectionUtils.isEmpty((Collection)deleteRows)) {
            return;
        }
        ArrayList<Pair<Pair<Serializable[], BitSet>, Pair<Serializable[], BitSet>>> rows = new ArrayList<Pair<Pair<Serializable[], BitSet>, Pair<Serializable[], BitSet>>>();
        for (Serializable[] row : deleteRows) {
            Pair<Serializable[], BitSet> item = new Pair<Serializable[], BitSet>(row, deleteRowsEventData.getIncludedColumns());
            rows.add(new Pair<Pair<Serializable[], BitSet>, Object>(item, null));
        }
        this.handleCdcDmlData(context, sourceMateData, tableId, rows, CdcDmlType.DELETE);
    }

    protected void handleGtidEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        GtidEventData gtidEvent = (GtidEventData)this.unwrapData(event);
        String gtid = gtidEvent.getMySqlGtid().toString();
        log.debug("Received GTID event: {}", (Object)gtid);
        this.localGtidSet.add(gtid);
        context.beginGtid(gtid);
    }

    protected void handleViewChangeEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
    }

    protected void handleXAPrepareTransactionEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
    }

    protected void handleTransactionCompletionEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        XidEventData xidEventData = (XidEventData)this.unwrapData(event);
        log.debug("Received XID event, Xid={}", (Object)xidEventData.getXid());
        context.commitTransaction();
    }

    protected void ignoreEvent(MysqlJdbcContext context, com.github.shyiko.mysql.binlog.event.Event event) {
        log.debug("Ignoring event due to missing handler: {}", (Object)event);
    }

    @Override
    public void registerCdcEventConsumer(EventConsumer consumer) {
        if (consumer == null) {
            return;
        }
        this.consumers.add(consumer);
    }

    @Override
    protected Set<String> defaultExcludeDatabase() {
        return MysqlConstants.DEFAULT_EXCLUDE_DATABASE;
    }

    @Override
    protected MysqlAntlr4DdlParser getDdlParser() {
        return this.ddlParser;
    }

    @Override
    public void setContext(MysqlJdbcContext context) {
        if (context == null) {
            context = MysqlJdbcContext.initialize(this.jdbcSourceConfig);
        }
        this.context = context;
    }

    public static enum CdcDmlType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

