/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.type;

public enum RowHandleMode {
    INSERT("+I", 1),
    UPDATE_BEFORE("-UB", 2),
    UPDATE_AFTER("+UA", 3),
    DELETE("-D", 1);

    private final String shortCut;
    private final byte value;

    private RowHandleMode(String shortCut, byte value) {
        this.shortCut = shortCut;
        this.value = value;
    }

    public String toShortCut() {
        return this.shortCut;
    }

    public byte toValue() {
        return this.value;
    }

    public static RowHandleMode fromByteValue(byte value) {
        switch (value) {
            case 0: {
                return INSERT;
            }
            case 1: {
                return UPDATE_BEFORE;
            }
            case 2: {
                return UPDATE_AFTER;
            }
            case 3: {
                return DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported byte value '" + value + "' for row handle mode.");
    }
}

