/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.type.mysql;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;
import org.apache.eventmesh.connector.jdbc.type.mysql.NumberType;

public class IntType
extends NumberType<Integer> {
    public static final IntType INSTANCE = new IntType();

    public IntType() {
        super(Integer.class, SQLType.INTEGER, "INT");
    }

    @Override
    public String getTypeName(Column<?> column) {
        Long length = Optional.ofNullable(column.getColumnLength()).orElse(0L);
        String typeName = this.hibernateDialect.getTypeName(column.getJdbcType().getVendorTypeNumber().intValue(), length.longValue(), length.intValue(), Optional.ofNullable(column.getDecimal()).orElse(0).intValue());
        StringBuilder typeNameBuilder = new StringBuilder(length > 0L ? typeName + "(" + length + ")" : typeName);
        typeNameBuilder.append(this.convertOptions2Sql(column));
        return typeNameBuilder.toString();
    }

    @Override
    public List<String> ofRegistrationKeys() {
        return Arrays.asList("INT32", this.getName(), "int");
    }
}

