/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.type.mysql;

import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlOptions;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;
import org.apache.eventmesh.connector.jdbc.type.AbstractType;

public abstract class NumberType<T>
extends AbstractType<T> {
    public NumberType(Class<T> typeClass, SQLType sqlType, String name) {
        super(typeClass, sqlType, name);
    }

    @Override
    public String getTypeName(Column<?> column) {
        Long length = Optional.ofNullable(column.getColumnLength()).orElse(0L);
        String typeName = this.hibernateDialect.getTypeName(column.getJdbcType().getVendorTypeNumber().intValue(), length.longValue(), length.intValue(), Optional.ofNullable(column.getDecimal()).orElse(0).intValue());
        return typeName;
    }

    protected String convertOptions2Sql(Column<?> column) {
        StringBuilder builder = new StringBuilder();
        if (MapUtils.isNotEmpty((Map)column.getOptions())) {
            String zerofill;
            String unsigned = (String)column.getOptions().get(MysqlOptions.MysqlColumnOptions.UNSIGNED);
            if (unsigned != null) {
                builder.append(" ").append(unsigned);
            }
            if ((zerofill = (String)column.getOptions().get(MysqlOptions.MysqlColumnOptions.ZEROFILL)) != null) {
                builder.append(" ").append(zerofill);
            }
        }
        return builder.toString();
    }
}

