/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.type.mysql;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.apache.eventmesh.connector.jdbc.JdbcDriverMetaData;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;
import org.apache.eventmesh.connector.jdbc.type.AbstractType;
import org.apache.eventmesh.connector.jdbc.utils.JdbcStringUtils;

public class YearType
extends AbstractType<Integer> {
    public static final YearType INSTANCE = new YearType();

    private YearType() {
        super(Integer.class, SQLType.INTEGER, "YEAR");
    }

    @Override
    public List<String> ofRegistrationKeys() {
        return Arrays.asList(this.getName(), "year", "Year");
    }

    @Override
    public String getTypeName(Column<?> column) {
        JdbcDriverMetaData jdbcDriverMetaData = this.eventMeshDialect.getJdbcDriverMetaData();
        if (JdbcStringUtils.compareVersion(jdbcDriverMetaData.getDatabaseProductVersion(), "8.0.19") >= 0) {
            return "year";
        }
        if (column.getColumnLength() != null && column.getColumnLength() <= 2L && JdbcStringUtils.compareVersion(jdbcDriverMetaData.getDatabaseProductVersion(), "8.0") >= 0) {
            return "year(4)";
        }
        return column.getColumnLength() == null ? "year" : "year(" + column.getColumnLength() + ")";
    }

    @Override
    public String getDefaultValue(DatabaseDialect<?> databaseDialect, Column<?> column) {
        Object defaultValue = column.getDefaultValue();
        if (defaultValue == null) {
            return "NULL";
        }
        return "'" + LocalDate.parse(defaultValue.toString()).getYear() + "'";
    }

    @Override
    public Object convert2DatabaseTypeValue(Object value) {
        if (value == null) {
            return null;
        }
        return LocalDate.parse(value.toString()).getYear();
    }
}

