/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log;

import com.alipay.sofa.common.log.AssertUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SpaceId {
    private final Map<String, String> tags = new HashMap<String, String>();
    private final String spaceName;

    public SpaceId(String spaceName) {
        AssertUtil.notNull(spaceName);
        this.spaceName = spaceName;
    }

    public SpaceId withTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaceId spaceId = (SpaceId)o;
        if (this.tags != null ? !this.tags.equals(spaceId.tags) : spaceId.tags != null) {
            return false;
        }
        return this.spaceName != null ? this.spaceName.equals(spaceId.spaceName) : spaceId.spaceName == null;
    }

    public int hashCode() {
        int result = this.tags != null ? this.tags.hashCode() : 0;
        result = 31 * result + (this.spaceName != null ? this.spaceName.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.tags == null || this.tags.size() == 0) {
            return this.spaceName;
        }
        StringBuilder sb = new StringBuilder(this.spaceName);
        sb.append("[");
        Iterator<Map.Entry<String, String>> iterator = this.tags.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

