/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.type.AviatorDouble;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorType;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AviatorLong
extends AviatorNumber {
    public AviatorLong(Number number) {
        super(number);
    }

    public static AviatorLong valueOf(long l) {
        int offset = 128;
        if (l >= -128L && l <= 127L) {
            return LongCache.cache[(int)l + 128];
        }
        return new AviatorLong(l);
    }

    public static AviatorLong valueOf(Long l) {
        return AviatorLong.valueOf((long)l);
    }

    @Override
    public AviatorObject neg(Map<String, Object> env) {
        return AviatorLong.valueOf(-this.number.longValue());
    }

    @Override
    public int innerCompare(AviatorObject other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = (AviatorNumber)other;
        switch (other.getAviatorType()) {
            case Long: {
                if (this.number.longValue() > otherNum.longValue()) {
                    return 1;
                }
                if (this.number.longValue() < otherNum.longValue()) {
                    return -1;
                }
                return 0;
            }
            case Double: {
                return Double.compare(this.number.doubleValue(), otherNum.doubleValue());
            }
        }
        throw new ExpressionRuntimeException("Could not compare " + this + " with " + other);
    }

    @Override
    public AviatorObject innerDiv(AviatorObject other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = (AviatorNumber)other;
        switch (other.getAviatorType()) {
            case Long: {
                return AviatorLong.valueOf(this.number.longValue() / otherNum.longValue());
            }
        }
        return new AviatorDouble((double)this.number.longValue() / otherNum.doubleValue());
    }

    @Override
    public AviatorNumber innerAdd(AviatorNumber other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = other;
        switch (other.getAviatorType()) {
            case Long: {
                return AviatorLong.valueOf(this.number.longValue() + otherNum.longValue());
            }
        }
        return new AviatorDouble((double)this.number.longValue() + otherNum.doubleValue());
    }

    @Override
    public AviatorObject innerMod(AviatorObject other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = (AviatorNumber)other;
        switch (other.getAviatorType()) {
            case Long: {
                return AviatorLong.valueOf(this.number.longValue() % otherNum.longValue());
            }
        }
        return new AviatorDouble((double)this.number.longValue() % otherNum.doubleValue());
    }

    @Override
    public AviatorObject innerMult(AviatorObject other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = (AviatorNumber)other;
        switch (other.getAviatorType()) {
            case Long: {
                return AviatorLong.valueOf(this.number.longValue() * otherNum.longValue());
            }
        }
        return new AviatorDouble((double)this.number.longValue() * otherNum.doubleValue());
    }

    protected void ensureLong(AviatorObject other) {
        if (other.getAviatorType() != AviatorType.Long) {
            throw new ExpressionRuntimeException(other + " is not long type");
        }
    }

    @Override
    public AviatorObject bitAnd(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                return this.innerBitAnd(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerBitAnd(AviatorNumber.valueOf(otherValue));
                }
                return super.bitAnd(other, env);
            }
        }
        return super.bitAnd(other, env);
    }

    private AviatorObject innerBitAnd(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() & otherLong.longValue());
    }

    private AviatorObject innerBitOr(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() | otherLong.longValue());
    }

    private AviatorObject innerBitXor(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() ^ otherLong.longValue());
    }

    private AviatorObject innerShiftLeft(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() << (int)otherLong.longValue());
    }

    private AviatorObject innerShiftRight(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() >> (int)otherLong.longValue());
    }

    private AviatorObject innerUnsignedShiftRight(AviatorObject other) {
        this.ensureLong(other);
        AviatorLong otherLong = (AviatorLong)other;
        return AviatorLong.valueOf(this.number.longValue() >>> (int)otherLong.longValue());
    }

    @Override
    public AviatorObject bitNot(Map<String, Object> env) {
        return AviatorLong.valueOf(this.number.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public AviatorObject bitOr(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                return this.innerBitOr(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerBitOr(AviatorNumber.valueOf(otherValue));
                }
                return super.bitOr(other, env);
            }
        }
        return super.bitOr(other, env);
    }

    @Override
    public AviatorObject bitXor(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                return this.innerBitXor(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerBitXor(AviatorNumber.valueOf(otherValue));
                }
                return super.bitXor(other, env);
            }
        }
        return super.bitXor(other, env);
    }

    @Override
    public AviatorObject shiftLeft(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                return this.innerShiftLeft(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerShiftLeft(AviatorNumber.valueOf(otherValue));
                }
                return super.shiftLeft(other, env);
            }
        }
        return super.shiftLeft(other, env);
    }

    @Override
    public AviatorObject shiftRight(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                return this.innerShiftRight(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerShiftRight(AviatorNumber.valueOf(otherValue));
                }
                return super.shiftRight(other, env);
            }
        }
        return super.shiftRight(other, env);
    }

    @Override
    public AviatorObject unsignedShiftRight(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                return this.innerUnsignedShiftRight(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerUnsignedShiftRight(AviatorNumber.valueOf(otherValue));
                }
                return super.unsignedShiftRight(other, env);
            }
        }
        return super.unsignedShiftRight(other, env);
    }

    @Override
    public AviatorObject innerSub(AviatorObject other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = (AviatorNumber)other;
        switch (other.getAviatorType()) {
            case Long: {
                return AviatorLong.valueOf(this.number.longValue() - otherNum.longValue());
            }
        }
        return new AviatorDouble((double)this.number.longValue() - otherNum.doubleValue());
    }

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.Long;
    }

    private static class LongCache {
        static final AviatorLong[] cache = new AviatorLong[256];

        private LongCache() {
        }

        static {
            for (long i = 0L; i < (long)cache.length; ++i) {
                LongCache.cache[(int)i] = new AviatorLong(i - 128L);
            }
        }
    }
}

