/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.type.AviatorDouble;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorLong;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorString;
import com.googlecode.aviator.utils.TypeUtils;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AviatorNumber
extends AviatorObject {
    protected Number number;

    public AviatorNumber(Number number) {
        this.number = number;
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        return this.number;
    }

    public static AviatorNumber valueOf(Object value) {
        if (TypeUtils.isLong(value)) {
            return AviatorLong.valueOf(((Number)value).longValue());
        }
        if (TypeUtils.isDouble(value)) {
            return new AviatorDouble(((Number)value).doubleValue());
        }
        throw new ClassCastException("Could not cast " + value.getClass().getName() + " to Number");
    }

    public double doubleValue() {
        return this.number.doubleValue();
    }

    @Override
    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case String: {
                return new AviatorString(this.number.toString() + ((AviatorString)other).getLexeme());
            }
            case Long: 
            case Double: {
                return this.innerAdd((AviatorNumber)other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerAdd(AviatorNumber.valueOf(otherValue));
                }
                if (otherValue instanceof String) {
                    return new AviatorString(this.number.toString() + otherValue);
                }
                return super.add(other, env);
            }
        }
        return super.add(other, env);
    }

    @Override
    public AviatorObject sub(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                return this.innerSub(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerSub(AviatorNumber.valueOf(otherValue));
                }
                return super.sub(other, env);
            }
        }
        return super.sub(other, env);
    }

    @Override
    public AviatorObject mod(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                return this.innerMod(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerMod(AviatorNumber.valueOf(otherValue));
                }
                return super.mod(other, env);
            }
        }
        return super.mod(other, env);
    }

    @Override
    public AviatorObject div(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                return this.innerDiv(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerDiv(AviatorNumber.valueOf(otherValue));
                }
                return super.div(other, env);
            }
        }
        return super.div(other, env);
    }

    @Override
    public AviatorObject mult(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                return this.innerMult(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue instanceof Number) {
                    return this.innerMult(AviatorNumber.valueOf(otherValue));
                }
                return super.mult(other, env);
            }
        }
        return super.mult(other, env);
    }

    @Override
    public int compare(AviatorObject other, Map<String, Object> env) {
        if (this == other) {
            return 0;
        }
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                return this.innerCompare(other);
            }
            case JavaType: {
                AviatorJavaType otherJavaType = (AviatorJavaType)other;
                Object otherValue = otherJavaType.getValue(env);
                if (otherValue == null) {
                    return 1;
                }
                if (otherValue instanceof Number) {
                    return this.innerCompare(AviatorNumber.valueOf(otherValue));
                }
                throw new ExpressionRuntimeException("Could not compare " + this + " with " + other);
            }
            case Nil: {
                return 1;
            }
        }
        throw new ExpressionRuntimeException("Could not compare " + this + " with " + other);
    }

    public abstract AviatorObject innerSub(AviatorObject var1);

    public abstract AviatorObject innerMult(AviatorObject var1);

    public abstract AviatorObject innerMod(AviatorObject var1);

    public abstract AviatorObject innerDiv(AviatorObject var1);

    public abstract AviatorNumber innerAdd(AviatorNumber var1);

    public abstract int innerCompare(AviatorObject var1);

    public long longValue() {
        return this.number.longValue();
    }

    protected void ensureNumber(AviatorObject other) {
        switch (other.getAviatorType()) {
            case Long: 
            case Double: {
                break;
            }
            default: {
                throw new ExpressionRuntimeException(other + " is not a valid number");
            }
        }
    }
}

