/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorString;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.TypeUtils;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AviatorPattern
extends AviatorObject {
    final Pattern pattern;

    public AviatorPattern(String expression) {
        this.pattern = Pattern.compile(expression);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case String: {
                return new AviatorString(this.pattern.pattern() + ((AviatorString)other).lexeme);
            }
            case JavaType: {
                AviatorJavaType javaType = (AviatorJavaType)other;
                Object otherValue = javaType.getValue(env);
                if (TypeUtils.isString(otherValue)) {
                    return new AviatorString(this.pattern.pattern() + otherValue.toString());
                }
                return super.add(other, env);
            }
        }
        return super.add(other, env);
    }

    @Override
    public AviatorObject match(AviatorObject other, Map<String, Object> env) {
        switch (other.getAviatorType()) {
            case String: {
                AviatorString aviatorString = (AviatorString)other;
                Matcher m = this.pattern.matcher(aviatorString.lexeme);
                if (m.matches()) {
                    if (env != null && env != Collections.EMPTY_MAP) {
                        int groupCount = m.groupCount();
                        for (int i = 0; i <= groupCount; ++i) {
                            env.put("$" + i, m.group(i));
                        }
                    }
                    return AviatorBoolean.TRUE;
                }
                return AviatorBoolean.FALSE;
            }
            case JavaType: {
                AviatorJavaType javaType = (AviatorJavaType)other;
                Object javaValue = javaType.getValue(env);
                if (TypeUtils.isString(javaValue)) {
                    return this.match(new AviatorString(String.valueOf(javaValue)), env);
                }
                throw new ExpressionRuntimeException(this.desc(env) + " could not match " + other.desc(env));
            }
        }
        throw new ExpressionRuntimeException(this.desc(env) + " could not match " + other.desc(env));
    }

    @Override
    public int compare(AviatorObject other, Map<String, Object> env) {
        if (this == other) {
            return 0;
        }
        switch (other.getAviatorType()) {
            case Pattern: {
                return this.pattern.pattern().compareTo(((AviatorPattern)other).pattern.pattern());
            }
            case JavaType: {
                if (other.getValue(env) == null) {
                    return 1;
                }
                throw new ExpressionRuntimeException("Could not compare Pattern with " + (Object)((Object)other.getAviatorType()));
            }
            case Nil: {
                return 1;
            }
        }
        throw new ExpressionRuntimeException("Could not compare Pattern with " + (Object)((Object)other.getAviatorType()));
    }

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.Pattern;
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        return "/" + this.pattern.pattern() + "/";
    }
}

