/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler;

import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.common.profiler.message.ResultResponse;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.ResponseFutureListener;
import com.navercorp.pinpoint.profiler.metadata.AgentInfo;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.util.AgentInfoFactory;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentInfoSender {
    private static final long DEFAULT_AGENT_INFO_REFRESH_INTERVAL_MS = 86400000L;
    private static final long DEFAULT_AGENT_INFO_SEND_INTERVAL_MS = 3000L;
    private static final int DEFAULT_MAX_TRY_COUNT_PER_ATTEMPT = 3;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final EnhancedDataSender<MetaDataType, ResponseMessage> dataSender;
    private final AgentInfoFactory agentInfoFactory;
    private final long refreshIntervalMs;
    private final long sendIntervalMs;
    private final int maxTryPerAttempt;
    private final Scheduler scheduler;
    private final MessageConverter<Object, ResultResponse> messageConverter;

    private AgentInfoSender(Builder builder) {
        this.dataSender = builder.dataSender;
        this.agentInfoFactory = builder.agentInfoFactory;
        this.refreshIntervalMs = builder.refreshIntervalMs;
        this.sendIntervalMs = builder.sendIntervalMs;
        this.maxTryPerAttempt = builder.maxTryPerAttempt;
        this.scheduler = new Scheduler();
        this.messageConverter = builder.messageConverter;
    }

    public void start() {
        this.scheduler.start();
    }

    public void stop() {
        this.scheduler.stop();
        this.logger.info("AgentInfoSender stopped");
    }

    public void refresh() {
        this.scheduler.refresh();
    }

    public static class Builder {
        private final EnhancedDataSender<MetaDataType, ResponseMessage> dataSender;
        private final AgentInfoFactory agentInfoFactory;
        private long refreshIntervalMs = 86400000L;
        private long sendIntervalMs = 3000L;
        private int maxTryPerAttempt = 3;
        private MessageConverter<Object, ResultResponse> messageConverter;

        public Builder(EnhancedDataSender<MetaDataType, ResponseMessage> dataSender, AgentInfoFactory agentInfoFactory) {
            this.dataSender = Objects.requireNonNull(dataSender, "dataSender");
            this.agentInfoFactory = Objects.requireNonNull(agentInfoFactory, "agentInfoFactory");
        }

        public Builder refreshInterval(long refreshIntervalMs) {
            this.refreshIntervalMs = refreshIntervalMs;
            return this;
        }

        public Builder sendInterval(long sendIntervalMs) {
            this.sendIntervalMs = sendIntervalMs;
            return this;
        }

        public Builder maxTryPerAttempt(int maxTryCountPerAttempt) {
            this.maxTryPerAttempt = maxTryCountPerAttempt;
            return this;
        }

        public Builder setMessageConverter(MessageConverter<Object, ResultResponse> messageConverter) {
            this.messageConverter = messageConverter;
            return this;
        }

        public AgentInfoSender build() {
            if (this.refreshIntervalMs <= 0L) {
                throw new IllegalStateException("agentInfoRefreshIntervalMs must be greater than 0");
            }
            if (this.sendIntervalMs <= 0L) {
                throw new IllegalStateException("agentInfoSendIntervalMs must be greater than 0");
            }
            if (this.maxTryPerAttempt <= 0) {
                throw new IllegalStateException("maxTryPerAttempt must be greater than 0");
            }
            return new AgentInfoSender(this);
        }
    }

    private class AgentInfoSendTask
    extends TimerTask {
        private final SuccessListener taskHandler;
        private final int retryCount;
        private final AtomicInteger counter;

        private AgentInfoSendTask(SuccessListener taskHandler) {
            this(taskHandler, 0);
        }

        private AgentInfoSendTask(SuccessListener taskHandler, int retryCount) {
            this.taskHandler = Objects.requireNonNull(taskHandler, "taskHandler");
            this.retryCount = retryCount;
            this.counter = new AtomicInteger(0);
        }

        @Override
        public void run() {
            int runCount = this.counter.incrementAndGet();
            if (runCount > this.retryCount) {
                this.cancel();
                return;
            }
            boolean isSuccessful = this.sendAgentInfo();
            if (isSuccessful) {
                AgentInfoSender.this.logger.info("AgentInfo sent.");
                this.cancel();
                this.taskHandler.onSuccess();
            }
        }

        private boolean sendAgentInfo() {
            AgentInfo agentInfo = null;
            try {
                agentInfo = AgentInfoSender.this.agentInfoFactory.createAgentInfo();
                AgentInfoSender.this.logger.info("Sending AgentInfo={}", (Object)agentInfo);
                ResponseFutureListener listener = new ResponseFutureListener();
                AgentInfoSender.this.dataSender.request((Object)agentInfo, listener);
                ResponseMessage responseMessage = (ResponseMessage)listener.getResponseFuture().get(3000L, TimeUnit.MILLISECONDS);
                if (responseMessage == null) {
                    if (agentInfo != null && agentInfo.getAgentInformation() != null) {
                        AgentInfoSender.this.logger.warn("Failed to send agentInfo={}. result not set", (Object)agentInfo.getAgentInformation());
                    } else {
                        AgentInfoSender.this.logger.warn("Failed to send agentInfo. result not set");
                    }
                    return false;
                }
                ResultResponse result = (ResultResponse)AgentInfoSender.this.messageConverter.toMessage((Object)responseMessage);
                if (!result.isSuccess()) {
                    if (agentInfo != null && agentInfo.getAgentInformation() != null) {
                        AgentInfoSender.this.logger.warn("Failed to send agentInfo={}. request unsuccessful, response={}", (Object)agentInfo.getAgentInformation(), (Object)result.getMessage());
                    } else {
                        AgentInfoSender.this.logger.warn("Failed to send agentInfo. request unsuccessful, response={}", (Object)result.getMessage());
                    }
                }
                return result.isSuccess();
            }
            catch (ExecutionException ex) {
                this.logError(agentInfo, ex.getCause());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.logError(agentInfo, ex);
            }
            catch (TimeoutException ex) {
                this.logError(agentInfo, ex);
            }
            return false;
        }

        private void logError(AgentInfo agentInfo, Throwable cause) {
            if (agentInfo != null && agentInfo.getAgentInformation() != null) {
                AgentInfoSender.this.logger.warn("Failed to send agentInfo={}", (Object)agentInfo.getAgentInformation(), (Object)cause);
            } else {
                AgentInfoSender.this.logger.warn("Failed to send agentInfo", cause);
            }
        }
    }

    private class Scheduler {
        private static final long IMMEDIATE = 0L;
        private final Timer timer = new Timer("Pinpoint-AgentInfoSender-Timer", true);
        private final Object lock = new Object();
        private boolean isRunning = true;

        private Scheduler() {
            AgentInfoSendTask task = new AgentInfoSendTask(SuccessListener.NO_OP);
            task.run();
        }

        public void start() {
            SuccessListener successListener = new SuccessListener(){

                @Override
                public void onSuccess() {
                    Scheduler.this.schedule(this, AgentInfoSender.this.maxTryPerAttempt, AgentInfoSender.this.refreshIntervalMs, AgentInfoSender.this.sendIntervalMs);
                }
            };
            if (AgentInfoSender.this.logger.isDebugEnabled()) {
                AgentInfoSender.this.logger.debug("Start scheduler of agentInfoSender");
            }
            this.schedule(successListener, Integer.MAX_VALUE, 0L, AgentInfoSender.this.sendIntervalMs);
        }

        public void refresh() {
            if (AgentInfoSender.this.logger.isDebugEnabled()) {
                AgentInfoSender.this.logger.debug("Refresh scheduler of agentInfoSender");
            }
            this.schedule(SuccessListener.NO_OP, AgentInfoSender.this.maxTryPerAttempt, 0L, AgentInfoSender.this.sendIntervalMs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void schedule(SuccessListener successListener, int retryCount, long delay, long period) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isRunning) {
                    AgentInfoSendTask task = new AgentInfoSendTask(successListener, retryCount);
                    this.timer.scheduleAtFixedRate((TimerTask)task, delay, period);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.lock;
            synchronized (object) {
                this.isRunning = false;
                this.timer.cancel();
            }
        }
    }

    private static interface SuccessListener {
        public static final SuccessListener NO_OP = new SuccessListener(){

            @Override
            public void onSuccess() {
            }
        };

        public void onSuccess();
    }
}

