/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import com.navercorp.pinpoint.profiler.context.scope.DefaultTraceScopePool;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisableChildTrace
implements Trace {
    public static final String UNSUPPORTED_OPERATION = "disable async child trace";
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    private boolean closed = false;
    private DefaultTraceScopePool scopePool;
    private final LocalTraceRoot traceRoot;
    private int depth;
    private final SpanRecorder spanRecorder;
    private final SpanEventRecorder spanEventRecorder;

    public DisableChildTrace(LocalTraceRoot traceRoot, SpanRecorder spanRecorder, SpanEventRecorder spanEventRecorder) {
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.spanRecorder = Objects.requireNonNull(spanRecorder, "spanRecorder");
        this.spanEventRecorder = Objects.requireNonNull(spanEventRecorder, "spanEventRecorder");
    }

    public SpanEventRecorder traceBlockBegin() {
        return this.traceBlockBegin(-1);
    }

    public SpanEventRecorder traceBlockBegin(int stackId) {
        this.push();
        return this.getSpanEventRecorder();
    }

    public void traceBlockEnd() {
        this.traceBlockBegin(-1);
    }

    public void traceBlockEnd(int stackId) {
        this.pop();
    }

    private SpanEventRecorder getSpanEventRecorder() {
        return this.spanEventRecorder;
    }

    private int push() {
        return this.depth++;
    }

    private void pop() {
        --this.depth;
    }

    public boolean isRootStack() {
        return this.depth == 0;
    }

    public int getCallStackFrameId() {
        return -1;
    }

    private LocalTraceRoot getTraceRoot() {
        return this.traceRoot;
    }

    public long getId() {
        return this.getTraceRoot().getLocalTransactionId();
    }

    public long getStartTime() {
        return this.traceRoot.getTraceStartTime();
    }

    public TraceId getTraceId() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public boolean canSampled() {
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isAsync() {
        return true;
    }

    public SpanRecorder getSpanRecorder() {
        return this.spanRecorder;
    }

    public SpanEventRecorder currentSpanEventRecorder() {
        return this.spanEventRecorder;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            this.logger.debug("Already closed");
            return;
        }
        this.closed = true;
    }

    public TraceScope getScope(String name) {
        if (this.scopePool == null) {
            return null;
        }
        return this.scopePool.get(name);
    }

    public TraceScope addScope(String name) {
        if (this.scopePool == null) {
            this.scopePool = new DefaultTraceScopePool();
        }
        return this.scopePool.add(name);
    }

    public String toString() {
        return "DisableChildTrace{traceRoot=" + this.traceRoot + '}';
    }
}

