/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.exception;

import com.navercorp.pinpoint.profiler.context.exception.DefaultExceptionRecorder;
import com.navercorp.pinpoint.profiler.context.exception.ExceptionRecorder;
import com.navercorp.pinpoint.profiler.context.exception.ExceptionRecorderFactory;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionContext;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionContextFactory;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionWrapperFactory;
import com.navercorp.pinpoint.profiler.context.exception.sampler.ExceptionChainSampler;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import java.util.Objects;

public class DefaultExceptionRecorderFactory
implements ExceptionRecorderFactory {
    private final ExceptionChainSampler exceptionChainSampler;
    private final ExceptionWrapperFactory exceptionWrapperFactory;
    private final ExceptionContextFactory exceptionContextFactory;

    public DefaultExceptionRecorderFactory(ExceptionChainSampler exceptionChainSampler, ExceptionWrapperFactory exceptionWrapperFactory, ExceptionContextFactory exceptionContextFactory) {
        this.exceptionChainSampler = Objects.requireNonNull(exceptionChainSampler, "exceptionTraceSampler");
        this.exceptionWrapperFactory = Objects.requireNonNull(exceptionWrapperFactory, "exceptionWrapperFactory");
        this.exceptionContextFactory = Objects.requireNonNull(exceptionContextFactory, "exceptionContextFactory");
    }

    @Override
    public ExceptionRecorder newRecorder(TraceRoot traceRoot) {
        Objects.requireNonNull(traceRoot, "traceRoot");
        ExceptionContext exceptionContext = this.exceptionContextFactory.newExceptionContext(traceRoot);
        return new DefaultExceptionRecorder(this.exceptionChainSampler, this.exceptionWrapperFactory, exceptionContext);
    }
}

