/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.exception.model;

import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Arrays;
import java.util.Objects;

public class ExceptionWrapper {
    private static final String EMPTY_STRING = "";
    private final String exceptionClassName;
    private final String exceptionMessage;
    private final StackTraceElement[] stackTraceElements;
    private final long startTime;
    private final long exceptionId;
    private final int exceptionDepth;

    public ExceptionWrapper(String exceptionClassName, String exceptionMessage, StackTraceElement[] stackTraceElements, long startTime, long exceptionId, int exceptionDepth) {
        this.exceptionClassName = Objects.requireNonNull(exceptionClassName, "exceptionClassName");
        this.exceptionMessage = Objects.requireNonNull(exceptionMessage, "exceptionMessage");
        this.stackTraceElements = Objects.requireNonNull(stackTraceElements, "stackTraceElements");
        this.startTime = startTime;
        this.exceptionId = exceptionId;
        this.exceptionDepth = exceptionDepth;
    }

    public static ExceptionWrapper newException(Throwable throwable, long startTime, long exceptionId, int exceptionDepth, int maxErrorMessageLength) {
        if (throwable == null) {
            return null;
        }
        return new ExceptionWrapper(StringUtils.defaultIfEmpty((String)throwable.getClass().getName(), (String)EMPTY_STRING), StringUtils.abbreviate((String)throwable.getMessage(), (int)maxErrorMessageLength), throwable.getStackTrace(), startTime, exceptionId, exceptionDepth);
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public StackTraceElement[] getStackTraceElements() {
        return this.stackTraceElements;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getExceptionId() {
        return this.exceptionId;
    }

    public int getExceptionDepth() {
        return this.exceptionDepth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExceptionWrapper)) {
            return false;
        }
        ExceptionWrapper that = (ExceptionWrapper)o;
        if (this.startTime != that.startTime) {
            return false;
        }
        if (this.exceptionId != that.exceptionId) {
            return false;
        }
        if (this.exceptionDepth != that.exceptionDepth) {
            return false;
        }
        if (!this.exceptionClassName.equals(that.exceptionClassName)) {
            return false;
        }
        if (!this.exceptionMessage.equals(that.exceptionMessage)) {
            return false;
        }
        return Arrays.equals(this.stackTraceElements, that.stackTraceElements);
    }

    public int hashCode() {
        int result = this.exceptionClassName.hashCode();
        result = 31 * result + this.exceptionMessage.hashCode();
        result = 31 * result + Arrays.hashCode(this.stackTraceElements);
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (int)(this.exceptionId ^ this.exceptionId >>> 32);
        result = 31 * result + this.exceptionDepth;
        return result;
    }

    public String toString() {
        return "ExceptionWrapper{exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionMessage='" + this.exceptionMessage + '\'' + ", stackTraceElements=" + Arrays.toString(this.stackTraceElements) + ", startTime=" + this.startTime + ", exceptionId=" + this.exceptionId + ", exceptionDepth=" + this.exceptionDepth + '}';
    }
}

