/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.bootstrap.context.ServerMetaData;
import com.navercorp.pinpoint.bootstrap.context.ServiceInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.grpc.trace.PAgentInfo;
import com.navercorp.pinpoint.grpc.trace.PJvmInfo;
import com.navercorp.pinpoint.grpc.trace.PServerMetaData;
import com.navercorp.pinpoint.grpc.trace.PServiceInfo;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.JvmInformation;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.AgentInfoMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.JvmGcTypeMapper;
import com.navercorp.pinpoint.profiler.metadata.AgentInfo;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;

@Singleton
@Named
public class AgentInfoMapperImpl
implements AgentInfoMapper {
    private final JvmGcTypeMapper jvmGcTypeMapper;

    @Inject
    public AgentInfoMapperImpl(JvmGcTypeMapper jvmGcTypeMapper) {
        this.jvmGcTypeMapper = jvmGcTypeMapper;
    }

    @Override
    public PAgentInfo map(AgentInfo agentInfo) {
        String machineName;
        if (agentInfo == null) {
            return null;
        }
        PAgentInfo.Builder pAgentInfo = PAgentInfo.newBuilder();
        String hostIp = this.agentInfoAgentInformationHostIp(agentInfo);
        if (hostIp != null) {
            pAgentInfo.setIp(hostIp);
        }
        if ((machineName = this.agentInfoAgentInformationMachineName(agentInfo)) != null) {
            pAgentInfo.setHostname(machineName);
        }
        if (agentInfo != null) {
            pAgentInfo.setPorts(this.emptyPort(agentInfo));
        }
        pAgentInfo.setContainer(this.agentInfoAgentInformationContainer(agentInfo));
        pAgentInfo.setPid(this.agentInfoAgentInformationPid(agentInfo));
        pAgentInfo.setServiceType((int)this.agentInfoAgentInformationServerTypeCode(agentInfo));
        String jvmVersion = this.agentInfoAgentInformationJvmVersion(agentInfo);
        if (jvmVersion != null) {
            pAgentInfo.setVmVersion(jvmVersion);
        }
        if (agentInfo != null) {
            pAgentInfo.setAgentVersion(this.agentVersion(agentInfo));
        }
        if (agentInfo.getServerMetaData() != null) {
            pAgentInfo.setServerMetaData(this.map(agentInfo.getServerMetaData()));
        }
        if (agentInfo.getJvmInfo() != null) {
            pAgentInfo.setJvmInfo(this.map(agentInfo.getJvmInfo()));
        }
        return pAgentInfo.build();
    }

    @Override
    public PServerMetaData map(ServerMetaData serverMetaData) {
        if (serverMetaData == null) {
            return null;
        }
        PServerMetaData.Builder pServerMetaData = PServerMetaData.newBuilder();
        if (serverMetaData.getVmArgs() != null) {
            for (String vmArg : serverMetaData.getVmArgs()) {
                pServerMetaData.addVmArg(vmArg);
            }
        }
        if (serverMetaData.getServiceInfos() != null) {
            for (ServiceInfo serviceInfo : serverMetaData.getServiceInfos()) {
                pServerMetaData.addServiceInfo(this.map(serviceInfo));
            }
        }
        if (serverMetaData.getServerInfo() != null) {
            pServerMetaData.setServerInfo(serverMetaData.getServerInfo());
        }
        return pServerMetaData.build();
    }

    @Override
    public PServiceInfo map(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return null;
        }
        PServiceInfo.Builder pServiceInfo = PServiceInfo.newBuilder();
        if (serviceInfo.getServiceLibs() != null) {
            for (String serviceLib : serviceInfo.getServiceLibs()) {
                pServiceInfo.addServiceLib(serviceLib);
            }
        }
        if (serviceInfo.getServiceName() != null) {
            pServiceInfo.setServiceName(serviceInfo.getServiceName());
        }
        return pServiceInfo.build();
    }

    @Override
    public PJvmInfo map(JvmInformation jvmInformation) {
        if (jvmInformation == null) {
            return null;
        }
        PJvmInfo.Builder pJvmInfo = PJvmInfo.newBuilder();
        if (jvmInformation.getJvmVersion() != null) {
            pJvmInfo.setVmVersion(jvmInformation.getJvmVersion());
        }
        if (jvmInformation.getJvmGcType() != null) {
            pJvmInfo.setGcType(this.jvmGcTypeMapper.map(jvmInformation.getJvmGcType()));
        }
        return pJvmInfo.build();
    }

    private String agentInfoAgentInformationHostIp(AgentInfo agentInfo) {
        if (agentInfo == null) {
            return null;
        }
        AgentInformation agentInformation = agentInfo.getAgentInformation();
        if (agentInformation == null) {
            return null;
        }
        String hostIp = agentInformation.getHostIp();
        if (hostIp == null) {
            return null;
        }
        return hostIp;
    }

    private String agentInfoAgentInformationMachineName(AgentInfo agentInfo) {
        if (agentInfo == null) {
            return null;
        }
        AgentInformation agentInformation = agentInfo.getAgentInformation();
        if (agentInformation == null) {
            return null;
        }
        String machineName = agentInformation.getMachineName();
        if (machineName == null) {
            return null;
        }
        return machineName;
    }

    private boolean agentInfoAgentInformationContainer(AgentInfo agentInfo) {
        if (agentInfo == null) {
            return false;
        }
        AgentInformation agentInformation = agentInfo.getAgentInformation();
        if (agentInformation == null) {
            return false;
        }
        boolean container = agentInformation.isContainer();
        return container;
    }

    private int agentInfoAgentInformationPid(AgentInfo agentInfo) {
        if (agentInfo == null) {
            return 0;
        }
        AgentInformation agentInformation = agentInfo.getAgentInformation();
        if (agentInformation == null) {
            return 0;
        }
        int pid = agentInformation.getPid();
        return pid;
    }

    private short agentInfoAgentInformationServerTypeCode(AgentInfo agentInfo) {
        if (agentInfo == null) {
            return 0;
        }
        AgentInformation agentInformation = agentInfo.getAgentInformation();
        if (agentInformation == null) {
            return 0;
        }
        ServiceType serverType = agentInformation.getServerType();
        if (serverType == null) {
            return 0;
        }
        short code = serverType.getCode();
        return code;
    }

    private String agentInfoAgentInformationJvmVersion(AgentInfo agentInfo) {
        if (agentInfo == null) {
            return null;
        }
        AgentInformation agentInformation = agentInfo.getAgentInformation();
        if (agentInformation == null) {
            return null;
        }
        String jvmVersion = agentInformation.getJvmVersion();
        if (jvmVersion == null) {
            return null;
        }
        return jvmVersion;
    }
}

