/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.grpc.trace.PActiveTrace;
import com.navercorp.pinpoint.grpc.trace.PAgentStat;
import com.navercorp.pinpoint.grpc.trace.PAgentStatBatch;
import com.navercorp.pinpoint.grpc.trace.PCpuLoad;
import com.navercorp.pinpoint.grpc.trace.PDataSource;
import com.navercorp.pinpoint.grpc.trace.PDataSourceList;
import com.navercorp.pinpoint.grpc.trace.PDeadlock;
import com.navercorp.pinpoint.grpc.trace.PDirectBuffer;
import com.navercorp.pinpoint.grpc.trace.PFileDescriptor;
import com.navercorp.pinpoint.grpc.trace.PJvmGc;
import com.navercorp.pinpoint.grpc.trace.PJvmGcDetailed;
import com.navercorp.pinpoint.grpc.trace.PLoadedClass;
import com.navercorp.pinpoint.grpc.trace.PResponseTime;
import com.navercorp.pinpoint.grpc.trace.PTotalThread;
import com.navercorp.pinpoint.grpc.trace.PTransaction;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.AgentStatMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.JvmGcTypeMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.MapperUtils;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshotBatch;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcDetailedMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.buffer.BufferMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSource;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSourceMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.DeadlockMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.filedescriptor.FileDescriptorMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.loadedclass.LoadedClassMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeValue;
import com.navercorp.pinpoint.profiler.monitor.metric.totalthread.TotalThreadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.transaction.TransactionMetricSnapshot;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;

@Singleton
@Named
public class AgentStatMapperImpl
implements AgentStatMapper {
    private final JvmGcTypeMapper jvmGcTypeMapper;

    @Inject
    public AgentStatMapperImpl(JvmGcTypeMapper jvmGcTypeMapper) {
        this.jvmGcTypeMapper = jvmGcTypeMapper;
    }

    @Override
    public PAgentStatBatch map(AgentStatMetricSnapshotBatch batch) {
        if (batch == null) {
            return null;
        }
        PAgentStatBatch.Builder pAgentStatBatch = this.newBuilder();
        if (batch.getAgentStats() != null) {
            for (AgentStatMetricSnapshot agentStat : batch.getAgentStats()) {
                pAgentStatBatch.addAgentStat(this.map(agentStat));
            }
        }
        return pAgentStatBatch.build();
    }

    @Override
    public PAgentStat map(AgentStatMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PAgentStat.Builder pAgentStat = PAgentStat.newBuilder();
        if (snapshot.getLoadedClassCount() != null) {
            pAgentStat.setLoadedClass(this.map(snapshot.getLoadedClassCount()));
        }
        pAgentStat.setTimestamp(snapshot.getTimestamp());
        pAgentStat.setCollectInterval(snapshot.getCollectInterval());
        if (snapshot.getGc() != null) {
            pAgentStat.setGc(this.map(snapshot.getGc()));
        }
        if (snapshot.getCpuLoad() != null) {
            pAgentStat.setCpuLoad(this.map(snapshot.getCpuLoad()));
        }
        if (snapshot.getTransaction() != null) {
            pAgentStat.setTransaction(this.map(snapshot.getTransaction()));
        }
        if (snapshot.getActiveTrace() != null) {
            pAgentStat.setActiveTrace(this.map(snapshot.getActiveTrace()));
        }
        if (snapshot.getDataSourceList() != null) {
            pAgentStat.setDataSourceList(this.map(snapshot.getDataSourceList()));
        }
        if (snapshot.getResponseTime() != null) {
            pAgentStat.setResponseTime(this.map(snapshot.getResponseTime()));
        }
        if (snapshot.getDeadlock() != null) {
            pAgentStat.setDeadlock(this.map(snapshot.getDeadlock()));
        }
        if (snapshot.getFileDescriptor() != null) {
            pAgentStat.setFileDescriptor(this.map(snapshot.getFileDescriptor()));
        }
        if (snapshot.getDirectBuffer() != null) {
            pAgentStat.setDirectBuffer(this.map(snapshot.getDirectBuffer()));
        }
        if (snapshot.getMetadata() != null) {
            pAgentStat.setMetadata(snapshot.getMetadata());
        }
        if (snapshot.getTotalThread() != null) {
            pAgentStat.setTotalThread(this.map(snapshot.getTotalThread()));
        }
        return pAgentStat.build();
    }

    @Override
    public PJvmGc map(JvmGcMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PJvmGc.Builder pJvmGc = PJvmGc.newBuilder();
        if (snapshot.getType() != null) {
            pJvmGc.setType(this.jvmGcTypeMapper.map(snapshot.getType()));
        }
        pJvmGc.setJvmMemoryHeapUsed(snapshot.getJvmMemoryHeapUsed());
        pJvmGc.setJvmMemoryHeapMax(snapshot.getJvmMemoryHeapMax());
        pJvmGc.setJvmMemoryNonHeapUsed(snapshot.getJvmMemoryNonHeapUsed());
        pJvmGc.setJvmMemoryNonHeapMax(snapshot.getJvmMemoryNonHeapMax());
        pJvmGc.setJvmGcOldCount(snapshot.getJvmGcOldCount());
        pJvmGc.setJvmGcOldTime(snapshot.getJvmGcOldTime());
        if (snapshot.getJvmGcDetailed() != null) {
            pJvmGc.setJvmGcDetailed(this.map(snapshot.getJvmGcDetailed()));
        }
        return pJvmGc.build();
    }

    @Override
    public PJvmGcDetailed map(JvmGcDetailedMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PJvmGcDetailed.Builder pJvmGcDetailed = PJvmGcDetailed.newBuilder();
        pJvmGcDetailed.setJvmGcNewCount(snapshot.getJvmGcNewCount());
        pJvmGcDetailed.setJvmGcNewTime(snapshot.getJvmGcNewTime());
        pJvmGcDetailed.setJvmPoolCodeCacheUsed(snapshot.getJvmPoolCodeCacheUsed());
        pJvmGcDetailed.setJvmPoolNewGenUsed(snapshot.getJvmPoolNewGenUsed());
        pJvmGcDetailed.setJvmPoolOldGenUsed(snapshot.getJvmPoolOldGenUsed());
        pJvmGcDetailed.setJvmPoolSurvivorSpaceUsed(snapshot.getJvmPoolSurvivorSpaceUsed());
        pJvmGcDetailed.setJvmPoolPermGenUsed(snapshot.getJvmPoolPermGenUsed());
        pJvmGcDetailed.setJvmPoolMetaspaceUsed(snapshot.getJvmPoolMetaspaceUsed());
        return pJvmGcDetailed.build();
    }

    @Override
    public PCpuLoad map(CpuLoadMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PCpuLoad.Builder pCpuLoad = PCpuLoad.newBuilder();
        pCpuLoad.setJvmCpuLoad(snapshot.getJvmCpuUsage());
        pCpuLoad.setSystemCpuLoad(snapshot.getSystemCpuUsage());
        return pCpuLoad.build();
    }

    @Override
    public PTransaction map(TransactionMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PTransaction.Builder pTransaction = PTransaction.newBuilder();
        pTransaction.setSampledNewCount(snapshot.getSampledNewCount());
        pTransaction.setSampledContinuationCount(snapshot.getSampledContinuationCount());
        pTransaction.setUnsampledNewCount(snapshot.getUnsampledNewCount());
        pTransaction.setUnsampledContinuationCount(snapshot.getUnsampledContinuationCount());
        pTransaction.setSkippedNewCount(snapshot.getSkippedNewCount());
        pTransaction.setSkippedContinuationCount(snapshot.getSkippedContinuationCount());
        return pTransaction.build();
    }

    @Override
    public PActiveTrace map(ActiveTraceHistogram histogram) {
        if (histogram == null) {
            return null;
        }
        PActiveTrace.Builder pActiveTrace = PActiveTrace.newBuilder();
        if (histogram != null) {
            pActiveTrace.setHistogram(this.toPHistogram(histogram));
        }
        return pActiveTrace.build();
    }

    @Override
    public PDataSourceList map(DataSourceMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PDataSourceList.Builder pDataSourceList = PDataSourceList.newBuilder();
        if (snapshot.getDataSourceList() != null) {
            for (DataSource dataSourceList : snapshot.getDataSourceList()) {
                pDataSourceList.addDataSource(this.map(dataSourceList));
            }
        }
        return pDataSourceList.build();
    }

    @Override
    public PDataSource map(DataSource dataSource) {
        if (dataSource == null) {
            return null;
        }
        PDataSource.Builder pDataSource = PDataSource.newBuilder();
        pDataSource.setActiveConnectionSize(dataSource.getActiveConnectionSize());
        pDataSource.setId(dataSource.getId());
        pDataSource.setServiceTypeCode((int)dataSource.getServiceTypeCode());
        if (dataSource.getDatabaseName() != null) {
            pDataSource.setDatabaseName(dataSource.getDatabaseName());
        }
        if (dataSource.getUrl() != null) {
            pDataSource.setUrl(dataSource.getUrl());
        }
        pDataSource.setMaxConnectionSize(dataSource.getMaxConnectionSize());
        return pDataSource.build();
    }

    @Override
    public PResponseTime map(ResponseTimeValue value) {
        if (value == null) {
            return null;
        }
        PResponseTime.Builder pResponseTime = PResponseTime.newBuilder();
        if (MapperUtils.isNotZero(value.getAvg())) {
            pResponseTime.setAvg(value.getAvg());
        }
        if (MapperUtils.isNotZero(value.getMax())) {
            pResponseTime.setMax(value.getMax());
        }
        return pResponseTime.build();
    }

    @Override
    public PDeadlock map(DeadlockMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PDeadlock.Builder pDeadlock = PDeadlock.newBuilder();
        pDeadlock.setCount(snapshot.getDeadlockedThreadCount());
        return pDeadlock.build();
    }

    @Override
    public PFileDescriptor map(FileDescriptorMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PFileDescriptor.Builder pFileDescriptor = PFileDescriptor.newBuilder();
        pFileDescriptor.setOpenFileDescriptorCount(snapshot.getOpenFileDescriptorCount());
        return pFileDescriptor.build();
    }

    @Override
    public PDirectBuffer map(BufferMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PDirectBuffer.Builder pDirectBuffer = PDirectBuffer.newBuilder();
        pDirectBuffer.setDirectCount(snapshot.getDirectCount());
        pDirectBuffer.setDirectMemoryUsed(snapshot.getDirectMemoryUsed());
        pDirectBuffer.setMappedCount(snapshot.getMappedCount());
        pDirectBuffer.setMappedMemoryUsed(snapshot.getMappedMemoryUsed());
        return pDirectBuffer.build();
    }

    @Override
    public PTotalThread map(TotalThreadMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PTotalThread.Builder pTotalThread = PTotalThread.newBuilder();
        pTotalThread.setTotalThreadCount((long)snapshot.getTotalThreadCount());
        return pTotalThread.build();
    }

    @Override
    public PLoadedClass map(LoadedClassMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PLoadedClass.Builder pLoadedClass = PLoadedClass.newBuilder();
        pLoadedClass.setLoadedClassCount((long)snapshot.getLoadedClassCount());
        pLoadedClass.setUnloadedClassCount(snapshot.getUnloadedClassCount());
        return pLoadedClass.build();
    }
}

