/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.common.util.StringUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.mapstruct.Condition;
import org.mapstruct.Qualifier;

public class MapperUtils {
    @Condition
    @IsNotEmptyString
    public static boolean isNotEmpty(String value) {
        return !StringUtils.isEmpty((String)value);
    }

    @Condition
    @IsNotZeroShort
    public static boolean isNotZero(short value) {
        return value != 0;
    }

    @Condition
    @IsNotZeroLong
    public static boolean isNotZero(long value) {
        return value != 0L;
    }

    @Condition
    @IsNotMinusOne
    public static boolean isNotMinusOne(int v) {
        return v != -1;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    @Qualifier
    public static @interface IsNotMinusOne {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    @Qualifier
    public static @interface IsNotZeroLong {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    @Qualifier
    public static @interface IsNotZeroShort {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    @Qualifier
    public static @interface IsNotEmptyString {
    }
}

