/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.grpc.trace.PMonitorInfo;
import com.navercorp.pinpoint.grpc.trace.PThreadDump;
import com.navercorp.pinpoint.grpc.trace.PThreadState;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.ThreadDumpMapper;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.MonitorInfoMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.ThreadDumpMetricSnapshot;

public class ThreadDumpMapperImpl
implements ThreadDumpMapper {
    @Override
    public PThreadDump map(ThreadDumpMetricSnapshot snapshot) {
        if (snapshot == null) {
            return null;
        }
        PThreadDump.Builder pThreadDump = PThreadDump.newBuilder();
        if (snapshot.getThreadState() != null) {
            pThreadDump.setThreadState(this.map(snapshot.getThreadState()));
        }
        if (snapshot.getLockedMonitors() != null) {
            for (MonitorInfoMetricSnapshot lockedMonitor : snapshot.getLockedMonitors()) {
                pThreadDump.addLockedMonitor(this.map(lockedMonitor));
            }
        }
        if (snapshot.getThreadName() != null) {
            pThreadDump.setThreadName(snapshot.getThreadName());
        }
        pThreadDump.setThreadId(snapshot.getThreadId());
        pThreadDump.setBlockedTime(snapshot.getBlockedTime());
        pThreadDump.setBlockedCount(snapshot.getBlockedCount());
        pThreadDump.setWaitedTime(snapshot.getWaitedTime());
        pThreadDump.setWaitedCount(snapshot.getWaitedCount());
        if (snapshot.getLockName() != null) {
            pThreadDump.setLockName(snapshot.getLockName());
        }
        pThreadDump.setLockOwnerId(snapshot.getLockOwnerId());
        if (snapshot.getLockOwnerName() != null) {
            pThreadDump.setLockOwnerName(snapshot.getLockOwnerName());
        }
        pThreadDump.setInNative(snapshot.isInNative());
        pThreadDump.setSuspended(snapshot.isSuspended());
        this.addAll(snapshot, pThreadDump);
        return pThreadDump.build();
    }

    @Override
    public PThreadState map(Thread.State state) {
        PThreadState pThreadState;
        if (state == null) {
            return null;
        }
        switch (state) {
            case NEW: {
                pThreadState = PThreadState.THREAD_STATE_NEW;
                break;
            }
            case RUNNABLE: {
                pThreadState = PThreadState.THREAD_STATE_RUNNABLE;
                break;
            }
            case BLOCKED: {
                pThreadState = PThreadState.THREAD_STATE_BLOCKED;
                break;
            }
            case WAITING: {
                pThreadState = PThreadState.THREAD_STATE_WAITING;
                break;
            }
            case TIMED_WAITING: {
                pThreadState = PThreadState.THREAD_STATE_TIMED_WAITING;
                break;
            }
            case TERMINATED: {
                pThreadState = PThreadState.THREAD_STATE_TERMINATED;
                break;
            }
            default: {
                pThreadState = PThreadState.THREAD_STATE_UNKNOWN;
            }
        }
        return pThreadState;
    }

    @Override
    public PMonitorInfo map(MonitorInfoMetricSnapshot monitorInfoMetricSnapshot) {
        if (monitorInfoMetricSnapshot == null) {
            return null;
        }
        PMonitorInfo.Builder pMonitorInfo = PMonitorInfo.newBuilder();
        pMonitorInfo.setStackDepth(monitorInfoMetricSnapshot.getStackDepth());
        if (monitorInfoMetricSnapshot.getStackFrame() != null) {
            pMonitorInfo.setStackFrame(monitorInfoMetricSnapshot.getStackFrame());
        }
        return pMonitorInfo.build();
    }
}

