/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.instrument.config.InstrumentConfig;
import com.navercorp.pinpoint.profiler.interceptor.registry.DefaultInterceptorRegistryBinder;
import com.navercorp.pinpoint.profiler.interceptor.registry.InterceptorRegistryBinder;
import java.util.Objects;

public class InterceptorRegistryBinderProvider
implements Provider<InterceptorRegistryBinder> {
    private final InterceptorRegistryBinder interceptorRegistryBinder;

    @Inject
    public InterceptorRegistryBinderProvider(InstrumentConfig instrumentConfig) {
        this(InterceptorRegistryBinderProvider.getInterceptorRegistrySize(instrumentConfig), InterceptorRegistryBinderProvider.getInterceptorHolderEnable(instrumentConfig));
    }

    private static int getInterceptorRegistrySize(InstrumentConfig instrumentConfig) {
        Objects.requireNonNull(instrumentConfig, "instrumentConfig");
        return instrumentConfig.getInterceptorRegistrySize();
    }

    private static boolean getInterceptorHolderEnable(InstrumentConfig instrumentConfig) {
        Objects.requireNonNull(instrumentConfig, "instrumentConfig");
        return instrumentConfig.getInterceptorHolderEnable();
    }

    public InterceptorRegistryBinderProvider(int interceptorSize, boolean interceptorHolderEnable) {
        this.interceptorRegistryBinder = new DefaultInterceptorRegistryBinder(interceptorSize, interceptorHolderEnable);
    }

    public InterceptorRegistryBinder get() {
        return this.interceptorRegistryBinder;
    }
}

