/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.metric;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.context.monitor.config.MonitorConfig;
import com.navercorp.pinpoint.profiler.context.monitor.metric.CustomMetricRegistryService;
import com.navercorp.pinpoint.profiler.context.monitor.metric.DefaultCustomMetricRegistryService;
import com.navercorp.pinpoint.profiler.context.monitor.metric.DisabledCustomMetricRegistryService;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomMetricRegistryServiceProvider
implements Provider<CustomMetricRegistryService> {
    private static final int DEFAULT_LIMIT_SIZE = 10;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final MonitorConfig monitorConfig;

    @Inject
    public CustomMetricRegistryServiceProvider(MonitorConfig monitorConfig) {
        this.monitorConfig = Objects.requireNonNull(monitorConfig, "monitorConfig");
    }

    public CustomMetricRegistryService get() {
        if (!this.monitorConfig.isCustomMetricEnable()) {
            return new DisabledCustomMetricRegistryService();
        }
        int customMetricLimitSize = this.monitorConfig.getCustomMetricLimitSize();
        if (customMetricLimitSize <= 0) {
            this.logger.info("recordLimitSize must greater than 0. It will be set default size {}", (Object)10);
            return new DefaultCustomMetricRegistryService(10);
        }
        return new DefaultCustomMetricRegistryService(customMetricLimitSize);
    }
}

